/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.it.utils;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;

public final class SocketUtils {
    private static final int PORT_RANGE_MIN = 1024;
    private static final int PORT_RANGE_MAX = 65535;
    private static final SecureRandom RND = new SecureRandom();

    private SocketUtils() {
    }

    public static final int findAvailablePort() {
        int candidatePort;
        int portRange = 64511;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available port in the range [%d, %d] after %d attempts", 1024, 65535, searchCounter));
            }
            candidatePort = SocketUtils.findRandomPort(1024, 65535);
            ++searchCounter;
        } while (!SocketUtils.isPortAvailable(candidatePort));
        return candidatePort;
    }

    private static final int findRandomPort(int minPort, int maxPort) {
        int portRange = maxPort - minPort;
        return minPort + RND.nextInt(portRange + 1);
    }

    private static final boolean isPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

