/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.acme.travels.TimersOnTaskModel;
import org.acme.travels.TimersOnTaskModelInput;
import org.acme.travels.TimersOnTaskModelOutput;
import org.acme.travels.TimersOnTask_1_TaskInput;
import org.acme.travels.TimersOnTask_1_TaskOutput;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/timersOnTask"})
@Component
public class TimersOnTaskResource {
    @Autowired
    @Qualifier(value="timersOnTask")
    Process<TimersOnTaskModel> process;
    @Autowired
    Application application;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> createResource_timersOnTask(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) TimersOnTaskModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            TimersOnTaskModelInput inputModel = resource != null ? resource : new TimersOnTaskModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            List startFromNode = httpHeaders.get((Object)"X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom((String)startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/timersOnTask/{id}").buildAndExpand(new Object[]{pi.id()});
            URI location = uriComponents.toUri();
            return ResponseEntity.created((URI)location).body((Object)((TimersOnTaskModel)pi.checkError().variables()).toOutput());
        });
    }

    @GetMapping(produces={"application/json"})
    public List<TimersOnTaskModelOutput> getResources_timersOnTask() {
        return this.process.instances().values().stream().map(pi -> ((TimersOnTaskModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> getResource_timersOnTask(@PathVariable(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok((Object)((TimersOnTaskModel)m.variables()).toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> deleteResource_timersOnTask(@PathVariable(value="id") String id) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((TimersOnTaskModel)pi.checkError().variables()).toOutput();
        }).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> updateModel_timersOnTask(@PathVariable(value="id") String id, @RequestBody(required=false) TimersOnTaskModel resource) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((TimersOnTaskModel)pi.updateVariables((Object)resource)).toOutput()).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public ResponseEntity<List<WorkItem>> getTasks_timersOnTask(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{id}/work/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> taskTransition_work_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) TimersOnTask_1_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((TimersOnTaskModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/work/{workItemId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> completeTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) TimersOnTask_1_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((TimersOnTaskModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PatchMapping(value={"/{id}/work/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TimersOnTask_1_TaskOutput> updateTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody Map<String, Object> model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)TimersOnTask_1_TaskOutput.fromMap((Map)pi.updateWorkItem(workItemId, model, Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/work/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<TimersOnTask_1_TaskInput> getTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id).map(pi -> TimersOnTask_1_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"work/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_work_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"work");
    }

    @GetMapping(value={"/{id}/work/{workItemId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_work_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"work"));
    }

    @DeleteMapping(value={"/{id}/work/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<TimersOnTaskModelOutput> abortTask_work_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((TimersOnTaskModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }
}

