/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.integrationtests.excetpion.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HelloService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloService.class);

    public String hello(String name) throws IOException {
        if (name.equals("exception")) {
            throw new IOException("what kind of name is that?");
        }
        if (name.equals("error")) {
            throw new ServiceException("Service Error");
        }
        HelloService.logMethodCall("hello", name);
        return "Hello " + name + "!";
    }

    public JsonNode jsonHello(JsonNode person) throws IOException {
        HelloService.logMethodCall("jsonHello", person);
        String retJsonStr = "{\"result\":\"Hello " + person.get("name").textValue() + "\"}";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(retJsonStr);
    }

    public String goodbye(String name) {
        HelloService.logMethodCall("goodbye", name);
        return "Goodbye " + name + "!";
    }

    public String helloMulti(String name, String lastName) {
        HelloService.logMethodCall("helloMulti", name, lastName);
        return "Hello (first and lastname) " + name.concat(" ").concat(lastName).concat("!");
    }

    public void helloNoOutput(String name, Integer age) {
        HelloService.logMethodCall("helloNoOutput", name, age);
    }

    public String helloOutput(String name, Integer age) {
        HelloService.logMethodCall("helloOutput", name, age);
        return "Hello " + name.concat(" ").concat(String.valueOf(age)).concat("!");
    }

    private static void logMethodCall(String method, Object ... arguments) {
        LOGGER.info("HelloService.{} invoked with params: {}", (Object)method, (Object)arguments);
    }

    public String echo(String input) {
        return input;
    }
}

