/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus;

import io.quarkus.test.common.http.TestHTTPResource;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusIntegrationTest
public class EndpointsIT {
    @TestHTTPResource(value="/")
    URL rootUrl;

    @Test
    public void endpointTest() {
        String url = this.rootUrl.toString() + "/q/openapi";
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        SwaggerParseResult result = new OpenAPIV3Parser().readLocation(url, null, parseOptions);
        Assertions.assertThat((List)result.getMessages()).isEmpty();
        OpenAPI openAPI = result.getOpenAPI();
        Assertions.assertThat((Map)openAPI.getPaths()).isNotEmpty();
    }

    @Test
    public void testGeneratedRestEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body("{\"p\": {\"name\": \"Paul\"}}").post("/dmnModel", new Object[0])).then()).statusCode(200)).body("d.Hello", Matchers.not((Matcher)Matchers.emptyOrNullString()), new Object[0]);
    }

    @Test
    public void testGeneratedResource() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/dmnDefinitions.json", new Object[0])).then()).statusCode(200)).body("definitions.tAddress.type", Matchers.is((Object)"object"), new Object[0]);
    }
}

