/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.LinkedList;
import java.util.Map;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.DataTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BusinessRuleTaskHandler
extends AbstractNodeHandler {
    private static final String NAMESPACE_PROP = "namespace";
    private static final String MODEL_PROP = "model";
    private static final String DECISION_PROP = "decision";
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    @Override
    protected Node createNode(Attributes attrs) {
        return new RuleSetNode();
    }

    public Class generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        String language = element.getAttribute("implementation");
        if (language == null || language.equalsIgnoreCase("##unspecified") || language.isEmpty()) {
            language = "http://www.jboss.org/drools/rule";
        }
        ruleSetNode.setLanguage(language);
        String ruleFlowGroup = element.getAttribute("ruleFlowGroup");
        if (ruleFlowGroup == null) {
            String namespace = (String)ruleSetNode.removeParameter(NAMESPACE_PROP);
            String model = (String)ruleSetNode.removeParameter(MODEL_PROP);
            String decision = (String)ruleSetNode.removeParameter(DECISION_PROP);
            if (namespace != null && model != null && decision != null) {
                ruleSetNode.setRuleType((RuleSetNode.RuleType)RuleSetNode.RuleType.decision((String)namespace, (String)model, (String)decision));
            }
        } else {
            ruleSetNode.setRuleType(RuleSetNode.RuleType.of((String)ruleFlowGroup, (String)language));
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs, this.dataInputTypes, this.dataOutputTypes);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, ruleSetNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, ruleSetNode, this.dataOutputs);
        }
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onExit");
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("businessRuleTask", (Node)ruleSetNode, xmlDump, metaDataType);
        RuleSetNode.RuleType ruleType = ruleSetNode.getRuleType();
        if (ruleType != null) {
            xmlDump.append("g:ruleFlowGroup=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleType.getName()) + "\" " + EOL);
        }
        xmlDump.append(" implementation=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleSetNode.getLanguage()) + "\" >" + EOL);
        this.writeExtensionElements((Node)ruleSetNode, xmlDump);
        this.writeIO(ruleSetNode, xmlDump);
        this.endNode("businessRuleTask", xmlDump);
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new IllegalArgumentException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression);
                subNode = subNode.getNextSibling();
            }
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            while (subNode != null) {
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment("XPath", from, to));
                subNode = subNode.getNextSibling();
            }
            ruleSetNode.addInAssociation(new DataAssociation(source, dataInputs.get(target), assignments, transformation));
        } else {
            String to = subNode.getTextContent();
            if ((subNode = subNode.getNextSibling()) != null) {
                String text;
                org.w3c.dom.Node subSubNode = subNode.getFirstChild();
                NodeList nl = subSubNode.getChildNodes();
                if (nl.getLength() > 1) {
                    ruleSetNode.setParameter(dataInputs.get(to), (Object)subSubNode.getTextContent());
                    return;
                }
                if (nl.getLength() == 0) {
                    return;
                }
                Object result = null;
                org.w3c.dom.Node from = nl.item(0);
                result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
                ruleSetNode.setParameter(dataInputs.get(to), result);
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, RuleSetNode ruleSetNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String source = subNode.getTextContent();
        subNode = subNode.getNextSibling();
        String target = subNode.getTextContent();
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression, source);
            subNode = subNode.getNextSibling();
        }
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment("XPath", from, to));
            subNode = subNode.getNextSibling();
        }
        ruleSetNode.addOutAssociation(new DataAssociation(dataOutputs.get(source), target, assignments, transformation));
    }

    protected void writeIO(RuleSetNode ruleSetNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        for (Map.Entry entry : ruleSetNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getParameters().entrySet()) {
            if ("ActorId".equals(entry.getKey()) || entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL + "        <assignment>" + EOL + "          <from xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)entry.getValue().toString()) + "</from>" + EOL + "          <to xsi:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</to>" + EOL + "        </assignment>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : ruleSetNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)ruleSetNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

