/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.bpmn2;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.xml.SemanticModule;
import org.drools.core.xml.SemanticModules;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNExtensionsSemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnProcessReaderException;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.AbstractProcess;

public class BpmnProcess
extends AbstractProcess<BpmnVariables> {
    private static final SemanticModules BPMN_SEMANTIC_MODULES = new SemanticModules();
    private final Process process;

    public BpmnProcess(Process p) {
        this.process = p;
    }

    public BpmnProcess(Process p, ProcessConfig config) {
        super(config);
        this.process = p;
    }

    public ProcessInstance<BpmnVariables> createInstance(Model m) {
        return new BpmnProcessInstance(this, BpmnVariables.create(m.toMap()), this.createLegacyProcessRuntime());
    }

    public ProcessInstance<BpmnVariables> createInstance() {
        return new BpmnProcessInstance(this, BpmnVariables.create(), this.createLegacyProcessRuntime());
    }

    public ProcessInstance<BpmnVariables> createInstance(BpmnVariables variables) {
        return new BpmnProcessInstance(this, variables, this.createLegacyProcessRuntime());
    }

    public static List<BpmnProcess> from(Resource resource) {
        try {
            XmlProcessReader xmlReader = new XmlProcessReader(BPMN_SEMANTIC_MODULES, Thread.currentThread().getContextClassLoader());
            List processes = xmlReader.read(resource.getReader());
            return processes.stream().map(BpmnProcess::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new BpmnProcessReaderException(e);
        }
    }

    public Process legacyProcess() {
        return this.process;
    }

    public BpmnVariables createModel() {
        return BpmnVariables.create(new HashMap<String, Object>());
    }

    static {
        BPMN_SEMANTIC_MODULES.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        BPMN_SEMANTIC_MODULES.addSemanticModule((SemanticModule)new BPMNExtensionsSemanticModule());
        BPMN_SEMANTIC_MODULES.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
    }
}

