/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.bpmn2.handler.AbstractExceptionHandlingTaskHandler;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class SignallingTaskHandlerDecorator
extends AbstractExceptionHandlingTaskHandler {
    private final String eventType;
    private String workItemExceptionParameterName = "jbpm.workitem.exception";
    private final Map<String, Integer> processInstanceExceptionMap = new HashMap<String, Integer>();
    private int exceptionCountLimit = 1;

    public SignallingTaskHandlerDecorator(Class<? extends WorkItemHandler> originalTaskHandlerClass, String eventType) {
        super(originalTaskHandlerClass);
        this.eventType = eventType;
    }

    public SignallingTaskHandlerDecorator(WorkItemHandler originalTaskHandler, String eventType) {
        super(originalTaskHandler);
        this.eventType = eventType;
    }

    public SignallingTaskHandlerDecorator(Class<? extends WorkItemHandler> originalTaskHandlerClass, String eventType, int exceptionCountLimit) {
        super(originalTaskHandlerClass);
        this.eventType = eventType;
        this.exceptionCountLimit = exceptionCountLimit;
    }

    public SignallingTaskHandlerDecorator(WorkItemHandler originalTaskHandler, String eventType, int exceptionCountLimit) {
        super(originalTaskHandler);
        this.eventType = eventType;
        this.exceptionCountLimit = exceptionCountLimit;
    }

    public void setWorkItemExceptionParameterName(String parameterName) {
        this.workItemExceptionParameterName = parameterName;
    }

    public String getWorkItemExceptionParameterName() {
        return this.workItemExceptionParameterName;
    }

    @Override
    public void handleExecuteException(Throwable cause, WorkItem workItem, WorkItemManager manager) {
        if (this.getAndIncreaseExceptionCount(workItem.getProcessInstanceId()) >= this.exceptionCountLimit) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new WorkItemHandlerRuntimeException(cause, "Signalling process instance " + workItem.getProcessInstanceId() + " with '" + this.eventType + "' resulted this exception.");
        }
        workItem.getParameters().put(this.workItemExceptionParameterName, cause);
        ((org.drools.core.process.instance.WorkItemManager)manager).signalEvent(this.eventType, (Object)((org.drools.core.process.instance.WorkItem)workItem), workItem.getProcessInstanceId());
    }

    @Override
    public void handleAbortException(Throwable cause, WorkItem workItem, WorkItemManager manager) {
        if (this.getAndIncreaseExceptionCount(workItem.getProcessInstanceId()) < this.exceptionCountLimit) {
            workItem.getParameters().put(this.workItemExceptionParameterName, cause);
            ((org.drools.core.process.instance.WorkItemManager)manager).signalEvent(this.eventType, (Object)((org.drools.core.process.instance.WorkItem)workItem), workItem.getProcessInstanceId());
        }
    }

    private int getAndIncreaseExceptionCount(String processInstanceId) {
        Integer count = this.processInstanceExceptionMap.get(processInstanceId);
        if (count == null) {
            count = 0;
        }
        count = count + 1;
        this.processInstanceExceptionMap.put(processInstanceId, count);
        return count - 1;
    }

    public void setExceptionCountLimit(int limit) {
        this.exceptionCountLimit = limit;
    }

    public void clearProcessInstance(Long processInstanceId) {
        this.processInstanceExceptionMap.remove(processInstanceId);
    }

    public void clear() {
        this.processInstanceExceptionMap.clear();
    }
}

