/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.IntermediateLink;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.DataTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediateThrowEventHandler
extends AbstractNodeHandler {
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();
    public static final String LINK_NAME = "linkName";
    public static final String LINK_SOURCE = "source";
    public static final String LINK_TARGET = "target";

    @Override
    protected Node createNode(Attributes attrs) {
        return new ActionNode();
    }

    public Class generateNodeFor() {
        return Node.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        ActionNode node = (ActionNode)parser.getCurrent();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode((Node)node, element, uri, localName, parser);
                break;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.handleMessageNode((Node)node, element, uri, localName, parser);
                break;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode((Node)node, element, uri, localName, parser);
                break;
            }
            if ("compensateEventDefinition".equals(nodeName)) {
                this.handleThrowCompensationEventNode((Node)node, element, uri, localName, parser);
                break;
            }
            if (!"linkEventDefinition".equals(nodeName)) continue;
            ThrowLinkNode linkNode = new ThrowLinkNode();
            linkNode.setId(node.getId());
            this.handleLinkNode(element, (Node)linkNode, xmlNode, parser);
            NodeContainer nodeContainer = (NodeContainer)parser.getParent();
            nodeContainer.addNode((org.kie.api.definition.process.Node)linkNode);
            ((ProcessBuildData)parser.getData()).addNode((Node)node);
            return linkNode;
        }
        if (node.getAction() == null) {
            node.setAction((DroolsAction)new DroolsConsequenceAction("mvel", ""));
            node.setMetaData("NodeType", (Object)"IntermediateThrowEvent-None");
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        return node;
    }

    protected void handleLinkNode(Element element, Node node, org.w3c.dom.Node xmlLinkNode, ExtensibleXmlParser parser) {
        List<IntermediateLink> links;
        node.setName(element.getAttribute("name"));
        NamedNodeMap linkAttr = xmlLinkNode.getAttributes();
        String name = linkAttr.getNamedItem("name").getNodeValue();
        String id = element.getAttribute("id");
        node.setMetaData("UniqueId", (Object)id);
        node.setMetaData(LINK_NAME, (Object)name);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        IntermediateLink aLink = new IntermediateLink();
        aLink.setName(name);
        aLink.setUniqueId(id);
        for (org.w3c.dom.Node xmlNode = xmlLinkNode.getFirstChild(); null != xmlNode; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (LINK_TARGET.equals(nodeName)) {
                String target = xmlNode.getTextContent();
                node.setMetaData(LINK_TARGET, (Object)target);
            }
            if (!LINK_SOURCE.equals(nodeName)) continue;
            String source = xmlNode.getTextContent();
            ArrayList<String> sources = (ArrayList<String>)node.getMetaData().get(LINK_SOURCE);
            if (null == sources) {
                sources = new ArrayList<String>();
            }
            aLink.addSource(source);
            sources.add(source);
            node.setMetaData(LINK_SOURCE, sources);
        }
        aLink.configureThrow();
        if (nodeContainer instanceof RuleFlowProcess) {
            RuleFlowProcess process = (RuleFlowProcess)nodeContainer;
            links = (ArrayList<IntermediateLink>)process.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList<IntermediateLink>();
            }
            links.add(aLink);
            process.setMetaData("BPMN.ThrowLinks", links);
        } else if (nodeContainer instanceof CompositeNode) {
            CompositeNode subprocess = (CompositeNode)nodeContainer;
            links = (List)subprocess.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList();
            }
            links.add(aLink);
            subprocess.setMetaData("BPMN.ThrowLinks", links);
        }
    }

    public void handleSignalNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String inputName = ((Element)xmlNode).getAttribute("name");
                this.dataInputs.put(id, inputName);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName)) continue;
            String signalName = ((Element)xmlNode).getAttribute("signalRef");
            String variable = (String)actionNode.getMetaData("MappingVariable");
            signalName = this.checkSignalAndConvertToRealSignalNam(parser, signalName);
            actionNode.setMetaData("EventType", (Object)"signal");
            actionNode.setMetaData("Ref", (Object)signalName);
            actionNode.setMetaData("Variable", (Object)variable);
            if (this.dataInputs.containsValue("async")) {
                signalName = "ASYNC-" + signalName;
            }
            String signalExpression = this.getSignalExpression((NodeImpl)actionNode, signalName, "tVariable");
            actionNode.setAction((DroolsAction)new DroolsConsequenceAction("java", " Object tVariable = " + (variable == null ? "null" : variable) + ";org.jbpm.workflow.core.node.Transformation transformation = (org.jbpm.workflow.core.node.Transformation)kcontext.getNodeInstance().getNode().getMetaData().get(\"Transformation\");if (transformation != null) {  tVariable = new org.jbpm.process.core.event.EventTransformerImpl(transformation)  .transformEvent(" + (variable == null ? "null" : variable) + ");}" + signalExpression));
        }
    }

    public void handleMessageNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String inputName = ((Element)xmlNode).getAttribute("name");
                this.dataInputs.put(id, inputName);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            String variable = (String)actionNode.getMetaData("MappingVariable");
            Variable v = (Variable)((ProcessBuildData)parser.getData()).getMetaData("Variable");
            if (v != null) {
                variable = (String)v.getMetaData(variable);
            }
            actionNode.setMetaData("MessageType", (Object)message.getType());
            actionNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            actionNode.setMetaData("TriggerRef", (Object)message.getName());
            actionNode.setAction((DroolsAction)new DroolsConsequenceAction("java", " Object tVariable = " + (variable == null ? "null" : variable) + ";org.jbpm.workflow.core.node.Transformation transformation = (org.jbpm.workflow.core.node.Transformation)kcontext.getNodeInstance().getNode().getMetaData().get(\"Transformation\");if (transformation != null) {  tVariable = new org.jbpm.process.core.event.EventTransformerImpl(transformation)  .transformEvent(" + (variable == null ? "null" : variable) + ");}org.drools.core.process.instance.impl.WorkItemImpl workItem = new org.drools.core.process.instance.impl.WorkItemImpl();" + EOL + "workItem.setName(\"Send Task\");" + EOL + "workItem.setProcessInstanceId(kcontext.getProcessInstance().getId());" + EOL + "workItem.setParameter(\"MessageType\", \"" + message.getType() + "\");" + EOL + "workItem.setNodeInstanceId(kcontext.getNodeInstance().getId());" + EOL + "workItem.setNodeId(kcontext.getNodeInstance().getNodeId());" + EOL + "workItem.setDeploymentId((String) kcontext.getKnowledgeRuntime().getEnvironment().get(\"deploymentId\"));" + EOL + (variable == null ? "" : "workItem.setParameter(\"Message\", tVariable);" + EOL) + "((org.drools.core.process.instance.WorkItemManager) kcontext.getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem(workItem);"));
        }
    }

    public void handleEscalationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode);
                continue;
            }
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new IllegalArgumentException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                }
                String faultName = escalation.getEscalationCode();
                String variable = (String)actionNode.getMetaData("MappingVariable");
                actionNode.setAction((DroolsAction)new DroolsConsequenceAction("java", "org.jbpm.process.instance.context.exception.ExceptionScopeInstance scopeInstance = (org.jbpm.process.instance.context.exception.ExceptionScopeInstance) ((org.jbpm.workflow.instance.NodeInstance) kcontext.getNodeInstance()).resolveContextInstance(org.jbpm.process.core.context.exception.ExceptionScope.EXCEPTION_SCOPE, \"" + faultName + "\");" + EOL + "if (scopeInstance != null) {" + EOL + " Object tVariable = " + (variable == null ? "null" : variable) + ";org.jbpm.workflow.core.node.Transformation transformation = (org.jbpm.workflow.core.node.Transformation)kcontext.getNodeInstance().getNode().getMetaData().get(\"Transformation\");if (transformation != null) {  tVariable = new org.jbpm.process.core.event.EventTransformerImpl(transformation)  .transformEvent(" + (variable == null ? "null" : variable) + ");}  scopeInstance.handleException(\"" + faultName + "\", tVariable);" + EOL + "} else {" + EOL + "    ((org.jbpm.process.instance.ProcessInstance) kcontext.getProcessInstance()).setState(org.jbpm.process.instance.ProcessInstance.STATE_ABORTED);" + EOL + "}"));
                continue;
            }
            throw new IllegalArgumentException("General escalation is not yet supported");
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, ActionNode actionNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String eventVariable = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new IllegalArgumentException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression, (String)this.dataInputs.get(target));
                actionNode.setMetaData("Transformation", (Object)transformation);
            }
            if (eventVariable != null && eventVariable.trim().length() > 0) {
                if (this.dataInputs.containsKey(eventVariable)) {
                    eventVariable = (String)this.dataInputs.get(eventVariable);
                }
                actionNode.setMetaData("MappingVariable", (Object)eventVariable);
            }
        } else if ((subNode = subNode.getNextSibling()) != null) {
            String text;
            org.w3c.dom.Node subSubNode = subNode.getFirstChild();
            NodeList nl = subSubNode.getChildNodes();
            if (nl.getLength() > 1) {
                actionNode.setMetaData("MappingVariable", (Object)subSubNode.getTextContent());
                return;
            }
            if (nl.getLength() == 0) {
                return;
            }
            Object result = null;
            org.w3c.dom.Node from = nl.item(0);
            result = from instanceof Text ? ((text = ((Text)from).getTextContent()).startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text) : nl.item(0);
            actionNode.setMetaData("MappingVariable", (Object)("\"" + result + "\""));
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by action node handler");
    }
}

