/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.DataTransformer;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScriptTaskHandler
extends AbstractNodeHandler {
    private static Map<String, String> SUPPORTED_SCRIPT_FORMATS = new HashMap<String, String>();
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    public static void registerSupportedScriptFormat(String language, String dialect) {
        SUPPORTED_SCRIPT_FORMATS.put(language, dialect);
    }

    @Override
    protected Node createNode(Attributes attrs) {
        ActionNode result = new ActionNode();
        result.setAction((DroolsAction)new DroolsConsequenceAction());
        return result;
    }

    public Class generateNodeFor() {
        return Node.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        boolean isForCompensation;
        super.handleNode(node, element, uri, localName, parser);
        ActionNode actionNode = (ActionNode)node;
        node.setMetaData("NodeType", (Object)"ScriptTask");
        DroolsConsequenceAction action = (DroolsConsequenceAction)actionNode.getAction();
        if (action == null) {
            action = new DroolsConsequenceAction();
            actionNode.setAction((DroolsAction)action);
        }
        String language = element.getAttribute("scriptFormat");
        action.setDialect(SUPPORTED_SCRIPT_FORMATS.getOrDefault(language, "java"));
        action.setConsequence("");
        this.dataInputs.clear();
        this.dataOutputs.clear();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (xmlNode instanceof Element && "script".equals(nodeName)) {
                action.setConsequence(xmlNode.getTextContent());
                continue;
            }
            if ("ioSpecification".equals(nodeName)) {
                this.readIoSpecification(xmlNode, this.dataInputs, this.dataOutputs, this.dataInputTypes, this.dataOutputTypes);
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataInputAssociation(xmlNode, actionNode, this.dataInputs);
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataOutputAssociation(xmlNode, actionNode, this.dataOutputs);
        }
        actionNode.setMetaData("DataInputs", new HashMap(this.dataInputs));
        actionNode.setMetaData("DataOutputs", new HashMap(this.dataOutputs));
        String compensation = element.getAttribute("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            actionNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by action node handler");
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, ActionNode actionNode, Map<String, String> dataInputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            ArrayList<String> sources = new ArrayList<String>();
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
            while ("sourceRef".equals(subNode.getNodeName())) {
                sources.add(subNode.getTextContent());
                subNode = subNode.getNextSibling();
            }
            String target = subNode.getTextContent();
            Transformation transformation = null;
            if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
                String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
                String expression = subNode.getTextContent();
                DataTransformer transformer = this.transformerRegistry.find(lang);
                if (transformer == null) {
                    throw new ProcessParsingValidationException("No transformer registered for language " + lang);
                }
                transformation = new Transformation(lang, expression);
                subNode = subNode.getNextSibling();
            }
            LinkedList<Assignment> assignments = new LinkedList<Assignment>();
            while (subNode != null) {
                String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
                if (expressionLang == null || expressionLang.trim().isEmpty()) {
                    expressionLang = "XPath";
                }
                org.w3c.dom.Node ssubNode = subNode.getFirstChild();
                String from = ssubNode.getTextContent();
                String to = ssubNode.getNextSibling().getTextContent();
                assignments.add(new Assignment(expressionLang, from, to));
                subNode = subNode.getNextSibling();
            }
            actionNode.addInAssociation(new DataAssociation(sources, dataInputs.get(target), assignments, transformation));
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, ActionNode actionNode, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(subNode.getTextContent());
        subNode = subNode.getNextSibling();
        while ("sourceRef".equals(subNode.getNodeName())) {
            sources.add(subNode.getTextContent());
            subNode = subNode.getNextSibling();
        }
        String target = subNode.getTextContent();
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new ProcessParsingValidationException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression);
            subNode = subNode.getNextSibling();
        }
        LinkedList<Assignment> assignments = new LinkedList<Assignment>();
        while (subNode != null) {
            String expressionLang = ((Element)subNode).getAttribute("expressionLanguage");
            if (expressionLang == null || expressionLang.trim().isEmpty()) {
                expressionLang = "XPath";
            }
            org.w3c.dom.Node ssubNode = subNode.getFirstChild();
            String from = ssubNode.getTextContent();
            String to = ssubNode.getNextSibling().getTextContent();
            assignments.add(new Assignment(expressionLang, from, to));
            subNode = subNode.getNextSibling();
        }
        actionNode.addOutAssociation(new DataAssociation(sources.stream().map(source -> (String)dataOutputs.get(source)).collect(Collectors.toList()), target, assignments, transformation));
    }

    static {
        SUPPORTED_SCRIPT_FORMATS.put("http://www.java.com/java", "java");
        SUPPORTED_SCRIPT_FORMATS.put("http://www.omg.org/spec/FEEL/20140401", "FEEL");
        SUPPORTED_SCRIPT_FORMATS.put("application/feel", "FEEL");
    }
}

