/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.IntermediateLink;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.CompositeNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SequenceFlowHandler
extends BaseAbstractHandler
implements Handler {
    public SequenceFlowHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Variable.class);
        this.validPeers.add(Node.class);
        this.validPeers.add(SequenceFlow.class);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Association.class);
        this.validPeers.add(IntermediateLink.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        CompositeNode compositeNode;
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String sourceRef = attrs.getValue("sourceRef");
        String targetRef = attrs.getValue("targetRef");
        String bendpoints = attrs.getValue("g:bendpoints");
        String name = attrs.getValue("name");
        String priority = attrs.getValue("http://www.jboss.org/drools", "priority");
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        ArrayList<SequenceFlow> connections = null;
        if (nodeContainer instanceof RuleFlowProcess) {
            RuleFlowProcess process = (RuleFlowProcess)nodeContainer;
            connections = (ArrayList<SequenceFlow>)process.getMetaData("BPMN.Connections");
            if (connections == null) {
                connections = new ArrayList<SequenceFlow>();
                process.setMetaData("BPMN.Connections", connections);
            }
        } else if (nodeContainer instanceof CompositeNode && (connections = (List)(compositeNode = (CompositeNode)nodeContainer).getMetaData("BPMN.Connections")) == null) {
            connections = new ArrayList();
            compositeNode.setMetaData("BPMN.Connections", connections);
        }
        SequenceFlow connection = new SequenceFlow(id, sourceRef, targetRef);
        connection.setBendpoints(bendpoints);
        connection.setName(name);
        if (priority != null) {
            connection.setPriority(Integer.parseInt(priority));
        }
        if (connections != null) {
            connections.add(connection);
        }
        return connection;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        SequenceFlow sequenceFlow = (SequenceFlow)parser.getCurrent();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"conditionExpression".equals(nodeName)) continue;
            String expression = xmlNode.getTextContent();
            org.w3c.dom.Node languageNode = xmlNode.getAttributes().getNamedItem("language");
            if (languageNode != null) {
                String language = languageNode.getNodeValue();
                if ("http://www.java.com/java".equals(language)) {
                    sequenceFlow.setLanguage("java");
                } else if ("http://www.mvel.org/2.0".equals(language)) {
                    sequenceFlow.setLanguage("mvel");
                } else if ("http://www.jboss.org/drools/rule".equals(language)) {
                    sequenceFlow.setType("rule");
                } else if ("http://www.w3.org/1999/XPath".equals(language)) {
                    sequenceFlow.setLanguage("XPath");
                } else if ("http://www.omg.org/spec/FEEL/20140401".equals(language) || "http://www.omg.org/spec/DMN/20180521/FEEL/".equals(language)) {
                    sequenceFlow.setLanguage("FEEL");
                } else {
                    throw new ProcessParsingValidationException("Unknown language " + language);
                }
            }
            sequenceFlow.setExpression(expression);
        }
        return sequenceFlow;
    }

    public Class<?> generateNodeFor() {
        return SequenceFlow.class;
    }
}

