/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jbpm.bpmn2.handler.AbstractExceptionHandlingTaskHandler;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTaskHandlerDecorator
extends AbstractExceptionHandlingTaskHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoggingTaskHandlerDecorator.class);
    private int loggedExceptionsLimit = 100;
    private Queue<WorkItemExceptionInfo> exceptionInfoList = new ArrayDeque<WorkItemExceptionInfo>(this.loggedExceptionsLimit);
    private String configuredMessage = "{0} thrown when work item {1} ({2}) was {3}ed in process instance {4}.";
    private List<InputParameter> configuredInputList = new ArrayList<InputParameter>();
    private boolean printStackTrace = true;

    public LoggingTaskHandlerDecorator(Class<? extends KogitoWorkItemHandler> originalTaskHandlerClass, int logLimit) {
        super(originalTaskHandlerClass);
        this.initializeExceptionInfoList(logLimit);
    }

    public LoggingTaskHandlerDecorator(Class<? extends KogitoWorkItemHandler> originalTaskHandlerClass) {
        super(originalTaskHandlerClass);
    }

    public LoggingTaskHandlerDecorator(KogitoWorkItemHandler originalTaskHandler) {
        super(originalTaskHandler);
    }

    public synchronized void setLoggedMessageFormat(String logMessageFormat) {
        this.configuredMessage = logMessageFormat;
    }

    public synchronized void setLoggedMessageInput(List<InputParameter> inputParameterList) {
        this.configuredInputList = inputParameterList;
    }

    public synchronized void setLoggedExceptionInfoListSize(int loggedExceptionInfoListSize) {
        this.initializeExceptionInfoList(loggedExceptionInfoListSize);
    }

    public synchronized void setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
    }

    private void initializeExceptionInfoList(int listSize) {
        this.loggedExceptionsLimit = listSize;
        ArrayDeque<WorkItemExceptionInfo> newExceptionInfoList = new ArrayDeque<WorkItemExceptionInfo>(this.loggedExceptionsLimit + 1);
        newExceptionInfoList.addAll(this.exceptionInfoList);
        this.exceptionInfoList = newExceptionInfoList;
    }

    public synchronized List<WorkItemExceptionInfo> getWorkItemExceptionInfoList() {
        return new ArrayList<WorkItemExceptionInfo>(this.exceptionInfoList);
    }

    @Override
    public synchronized void handleExecuteException(Throwable cause, KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        if (this.exceptionInfoList.size() == this.loggedExceptionsLimit) {
            this.exceptionInfoList.poll();
        }
        this.exceptionInfoList.add(new WorkItemExceptionInfo(workItem, cause, true));
        this.logMessage(true, workItem, cause);
    }

    @Override
    public synchronized void handleAbortException(Throwable cause, KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        if (this.exceptionInfoList.size() == this.loggedExceptionsLimit) {
            this.exceptionInfoList.poll();
        }
        this.exceptionInfoList.add(new WorkItemExceptionInfo(workItem, cause, false));
        this.logMessage(false, workItem, cause);
    }

    private void logMessage(boolean onExecute, KogitoWorkItem workItem, Throwable cause) {
        String handlerMethodStem = "execut";
        if (!onExecute) {
            handlerMethodStem = "abort";
        }
        if (cause instanceof WorkItemHandlerRuntimeException) {
            cause = cause.getCause();
        }
        ArrayList<String> inputList = new ArrayList<String>();
        if (this.configuredInputList.isEmpty()) {
            if (workItem.getParameter("Interface") != null) {
                this.configuredMessage = "{0}.{1} threw {2} when {3}ing work item {4} in process instance {5}.";
                inputList.add((String)workItem.getParameter("Interface"));
                inputList.add((String)workItem.getParameter("Operation"));
                inputList.add(cause.getClass().getSimpleName());
                inputList.add(handlerMethodStem);
                inputList.add(workItem.getStringId());
                inputList.add(workItem.getProcessInstanceStringId());
            } else {
                inputList.add(cause.getClass().getSimpleName());
                inputList.add(workItem.getStringId());
                inputList.add(workItem.getName());
                inputList.add(handlerMethodStem);
                inputList.add(String.valueOf(workItem.getProcessInstanceStringId()));
            }
        } else {
            for (InputParameter inputType : this.configuredInputList) {
                switch (inputType) {
                    case EXCEPTION_CLASS: {
                        inputList.add(cause.getClass().getSimpleName());
                        break;
                    }
                    case WORK_ITEM_HANDLER_TYPE: {
                        inputList.add(this.getOriginalTaskHandler().getClass().getSimpleName());
                        break;
                    }
                    case WORK_ITEM_METHOD: {
                        inputList.add(onExecute ? "execut" : "abort");
                        break;
                    }
                    case WORK_ITEM_ID: {
                        inputList.add(workItem.getStringId());
                        break;
                    }
                    case WORK_ITEM_NAME: {
                        inputList.add(workItem.getName());
                        break;
                    }
                    case WORK_ITEM_PARAMETERS: {
                        StringBuilder parameters = new StringBuilder();
                        for (String param : workItem.getParameters().keySet()) {
                            parameters.append(param + " : " + workItem.getParameters().get(param) + ", ");
                        }
                        inputList.add(parameters.substring(0, parameters.length() - 2));
                        break;
                    }
                    case PROCESS_INSTANCE_ID: {
                        inputList.add(String.valueOf(workItem.getProcessInstanceStringId()));
                        break;
                    }
                    case SERVICE: {
                        inputList.add((String)workItem.getParameter("Interface"));
                        break;
                    }
                    case OPERATION: {
                        inputList.add((String)workItem.getParameter("Operation"));
                    }
                }
            }
        }
        String message = MessageFormat.format(this.configuredMessage, inputList.toArray());
        if (this.printStackTrace) {
            logger.warn(message, cause);
        } else {
            logger.warn(message);
        }
    }

    public static enum InputParameter {
        WORK_ITEM_ID,
        WORK_ITEM_NAME,
        WORK_ITEM_METHOD,
        WORK_ITEM_HANDLER_TYPE,
        WORK_ITEM_PARAMETERS,
        SERVICE,
        OPERATION,
        PROCESS_INSTANCE_ID,
        EXCEPTION_CLASS;

    }

    public class WorkItemExceptionInfo {
        private final Throwable cause;
        private final Date timeThrown = new Date();
        private final boolean onExecute;
        private final String processInstanceId;
        private final String workItemId;
        private final String workItemName;
        private final Map<String, Object> workItemParameters;

        public WorkItemExceptionInfo(KogitoWorkItem workItem, Throwable cause, boolean onExecute) {
            this.cause = cause;
            this.onExecute = onExecute;
            this.processInstanceId = workItem.getProcessInstanceStringId();
            this.workItemId = workItem.getStringId();
            this.workItemName = workItem.getName();
            this.workItemParameters = Collections.unmodifiableMap(workItem.getParameters());
        }

        public Throwable getException() {
            return this.cause;
        }

        public Date getTimeThrown() {
            return this.timeThrown;
        }

        public boolean onExecute() {
            return this.onExecute;
        }

        public String getProcessInstanceId() {
            return this.processInstanceId;
        }

        public String getWorkItemId() {
            return this.workItemId;
        }

        public String getWorkItemName() {
            return this.workItemName;
        }

        public Map<String, Object> getWorkItemParameters() {
            return this.workItemParameters;
        }
    }
}

