/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashMap;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BusinessRuleTaskHandler
extends AbstractNodeHandler {
    private static final String NAMESPACE_PROP = "namespace";
    private static final String MODEL_PROP = "model";
    private static final String DECISION_PROP = "decision";

    @Override
    protected Node createNode(Attributes attrs) {
        return new RuleSetNode();
    }

    public Class<RuleSetNode> generateNodeFor() {
        return RuleSetNode.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        ruleSetNode.setIoSpecification(this.readIOEspecification(parser, element));
        String language = element.getAttribute("implementation");
        if (language == null || language.equalsIgnoreCase("##unspecified") || language.isEmpty()) {
            language = "http://www.jboss.org/drools/rule";
        }
        ruleSetNode.setLanguage(language);
        String ruleFlowGroup = element.getAttribute("ruleFlowGroup");
        if (language.equals("http://www.jboss.org/drools/dmn")) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (DataAssociation dataAssociation : ruleSetNode.getIoSpecification().getDataInputAssociation()) {
                for (Assignment assignment : dataAssociation.getAssignments()) {
                    parameters.put(assignment.getTo().getLabel(), assignment.getFrom().getExpression());
                }
            }
            String namespace = (String)parameters.get(NAMESPACE_PROP);
            String model = (String)parameters.get(MODEL_PROP);
            String decision = (String)parameters.get(DECISION_PROP);
            ruleSetNode.setRuleType((RuleSetNode.RuleType)RuleSetNode.RuleType.decision((String)namespace, (String)model, (String)decision));
        } else {
            ruleSetNode.setRuleType(RuleSetNode.RuleType.of((String)ruleFlowGroup, (String)language));
        }
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)ruleSetNode, element, "onExit");
        return ruleSetNode;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        RuleSetNode ruleSetNode = (RuleSetNode)node;
        this.writeNode("businessRuleTask", (Node)ruleSetNode, xmlDump, metaDataType);
        RuleSetNode.RuleType ruleType = ruleSetNode.getRuleType();
        if (ruleType != null) {
            xmlDump.append("g:ruleFlowGroup=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleType.getName()) + "\" " + EOL);
        }
        xmlDump.append(" implementation=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(ruleSetNode.getLanguage()) + "\" >" + EOL);
        this.writeExtensionElements((Node)ruleSetNode, xmlDump);
        this.writeIO(ruleSetNode.getIoSpecification(), xmlDump);
        this.endNode("businessRuleTask", xmlDump);
    }
}

