/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.IntermediateLink;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.actions.HandleEscalationAction;
import org.jbpm.process.instance.impl.actions.HandleMessageAction;
import org.jbpm.process.instance.impl.actions.SignalProcessInstanceAction;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.IOSpecification;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediateThrowEventHandler
extends AbstractNodeHandler {
    public static final String LINK_NAME = "linkName";
    public static final String LINK_SOURCE = "source";
    public static final String LINK_TARGET = "target";

    @Override
    protected Node createNode(Attributes attrs) {
        return new ActionNode();
    }

    public Class<Node> generateNodeFor() {
        return Node.class;
    }

    @Override
    protected Node handleNode(Node newNode, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode;
        Node node = newNode;
        IOSpecification ioSpecification = this.readThrowSpecification(parser, element);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("signalEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, node);
                this.handleSignalNode(node, element, uri, localName, parser);
                break;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, node);
                this.handleMessageNode(node, element, uri, localName, parser);
                break;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, node);
                this.handleEscalationNode(node, element, uri, localName, parser);
                break;
            }
            if ("compensateEventDefinition".equals(nodeName)) {
                this.setThrowVariable(ioSpecification, node);
                this.handleThrowCompensationEventNode(node, element, uri, localName, parser);
                break;
            }
            if (!"linkEventDefinition".equals(nodeName)) continue;
            ThrowLinkNode linkNode = new ThrowLinkNode();
            linkNode.setId(node.getId());
            node = linkNode;
            this.setThrowVariable(ioSpecification, node);
            this.handleLinkNode(element, node, xmlNode, parser);
        }
        if (node instanceof ActionNode && (actionNode = (ActionNode)node).getAction() == null) {
            actionNode.setAction((DroolsAction)new DroolsConsequenceAction("java", ""));
            actionNode.setMetaData("NodeType", (Object)"IntermediateThrowEvent-None");
        }
        return node;
    }

    protected void handleLinkNode(Element element, Node node, org.w3c.dom.Node xmlLinkNode, ExtensibleXmlParser parser) {
        List<IntermediateLink> links;
        node.setName(element.getAttribute("name"));
        NamedNodeMap linkAttr = xmlLinkNode.getAttributes();
        String name = linkAttr.getNamedItem("name").getNodeValue();
        String id = element.getAttribute("id");
        node.setMetaData("UniqueId", (Object)id);
        node.setMetaData(LINK_NAME, (Object)name);
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        IntermediateLink aLink = new IntermediateLink();
        aLink.setName(name);
        aLink.setUniqueId(id);
        for (org.w3c.dom.Node xmlNode = xmlLinkNode.getFirstChild(); null != xmlNode; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (LINK_TARGET.equals(nodeName)) {
                String target = xmlNode.getTextContent();
                node.setMetaData(LINK_TARGET, (Object)target);
            }
            if (!LINK_SOURCE.equals(nodeName)) continue;
            String source = xmlNode.getTextContent();
            ArrayList<String> sources = (ArrayList<String>)node.getMetaData().get(LINK_SOURCE);
            if (null == sources) {
                sources = new ArrayList<String>();
            }
            aLink.addSource(source);
            sources.add(source);
            node.setMetaData(LINK_SOURCE, sources);
        }
        aLink.configureThrow();
        if (nodeContainer instanceof RuleFlowProcess) {
            RuleFlowProcess process = (RuleFlowProcess)nodeContainer;
            links = (ArrayList<IntermediateLink>)process.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList<IntermediateLink>();
            }
            links.add(aLink);
            process.setMetaData("BPMN.ThrowLinks", links);
        } else if (nodeContainer instanceof CompositeNode) {
            CompositeNode subprocess = (CompositeNode)nodeContainer;
            links = (List)subprocess.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList();
            }
            links.add(aLink);
            subprocess.setMetaData("BPMN.ThrowLinks", links);
        }
    }

    public void handleSignalNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"signalEventDefinition".equals(nodeName)) continue;
            Object signalName = ((Element)xmlNode).getAttribute("signalRef");
            String variable = this.findVariable((String)actionNode.getMetaData("MappingVariable"), parser);
            String inputVariable = this.findVariable((String)actionNode.getMetaData("MappingVariableInput"), parser);
            signalName = this.checkSignalAndConvertToRealSignalNam(parser, (String)signalName);
            actionNode.setMetaData("EventType", (Object)"signal");
            actionNode.setMetaData("Ref", signalName);
            actionNode.setMetaData("Variable", (Object)variable);
            List inputs = actionNode.getIoSpecification().getDataInputAssociation();
            if (!inputs.isEmpty()) {
                String type = ((DataAssociation)inputs.get(0)).getTarget().getType();
                actionNode.setMetaData("SignalType", (Object)type);
            }
            if (actionNode.getIoSpecification().containsInputLabel("async")) {
                signalName = "ASYNC-" + (String)signalName;
            }
            DroolsConsequenceAction action = ProcessHandler.createJavaAction((Action)new SignalProcessInstanceAction((String)signalName, variable, inputVariable, (String)actionNode.getMetaData("customScope")));
            actionNode.setAction((DroolsAction)action);
        }
    }

    public void handleMessageNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new ProcessParsingValidationException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new ProcessParsingValidationException("Could not find message " + messageRef);
            }
            String variable = (String)actionNode.getMetaData("MappingVariable");
            Variable v = (Variable)((ProcessBuildData)parser.getData()).getMetaData("Variable");
            if (v != null) {
                variable = (String)v.getMetaData(variable);
            }
            actionNode.setMetaData("EventType", (Object)"message");
            actionNode.setMetaData("MessageType", (Object)message.getType());
            actionNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            actionNode.setMetaData("TriggerRef", (Object)message.getName());
            DroolsConsequenceAction action = ProcessHandler.createJavaAction((Action)new HandleMessageAction(message.getType(), variable));
            actionNode.setAction((DroolsAction)action);
        }
    }

    public void handleEscalationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ActionNode actionNode = (ActionNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new ProcessParsingValidationException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new ProcessParsingValidationException("Could not find escalation " + escalationRef);
                }
                String faultName = escalation.getEscalationCode();
                String variable = (String)actionNode.getMetaData("MappingVariable");
                DroolsConsequenceAction action = ProcessHandler.createJavaAction((Action)new HandleEscalationAction(faultName, variable));
                actionNode.setAction((DroolsAction)action);
                continue;
            }
            throw new ProcessParsingValidationException("General escalation is not yet supported");
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by action node handler");
    }
}

