/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.NodeContainer;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubProcessHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        boolean isForCompensation;
        CompositeContextNode subProcessNode = new CompositeContextNode();
        String eventSubprocessAttribute = attrs.getValue("triggeredByEvent");
        if (eventSubprocessAttribute != null && Boolean.parseBoolean(eventSubprocessAttribute)) {
            subProcessNode = new EventSubProcessNode();
        }
        VariableScope variableScope = new VariableScope();
        subProcessNode.addContext((Context)variableScope);
        subProcessNode.setDefaultContext((Context)variableScope);
        String compensation = attrs.getValue("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            subProcessNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
        subProcessNode.setAutoComplete(true);
        return subProcessNode;
    }

    public Class<CompositeContextNode> generateNodeFor() {
        return CompositeContextNode.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        CompositeContextNode compositeNode = (CompositeContextNode)node;
        super.handleNode(node, element, uri, localName, parser);
        this.handleScript((ExtendedNodeImpl)compositeNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)compositeNode, element, "onExit");
        compositeNode.setIoSpecification(this.readIOEspecification(parser, element));
        compositeNode.setMultiInstanceSpecification(this.readMultiInstanceSpecification(parser, element, compositeNode.getIoSpecification()));
        CompositeContextNode outcome = compositeNode;
        if (compositeNode.getMultiInstanceSpecification().hasMultiInstanceInput()) {
            ForEachNode forEachNode = (ForEachNode)this.decorateMultiInstanceSpecificationSubProcess(compositeNode, compositeNode.getMultiInstanceSpecification());
            this.handleScript((ExtendedNodeImpl)forEachNode, element, "onEntry");
            this.handleScript((ExtendedNodeImpl)forEachNode, element, "onExit");
            List connections = (List)forEachNode.getMetaData("BPMN.Connections");
            ProcessHandler.linkConnections((NodeContainer)forEachNode, connections);
            ProcessHandler.linkBoundaryEvents((NodeContainer)forEachNode);
            List associations = (List)forEachNode.getMetaData("BPMN.Associations");
            ProcessHandler.linkAssociations((Definitions)forEachNode.getMetaData("Definitions"), (NodeContainer)forEachNode, associations);
            this.applyAsync(node, Boolean.parseBoolean((String)compositeNode.getMetaData().get("customAsync")));
            outcome = forEachNode;
        } else {
            this.handleCompositeContextNode(compositeNode);
        }
        org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)outcome);
        return outcome;
    }

    protected void handleCompositeContextNode(CompositeContextNode compositeNode) throws SAXException {
        List connections = (List)compositeNode.getMetaData("BPMN.Connections");
        List throwLinks = (List)compositeNode.getMetaData("BPMN.ThrowLinks");
        ProcessHandler.linkIntermediateLinks((NodeContainer)compositeNode, throwLinks);
        ProcessHandler.linkConnections((NodeContainer)compositeNode, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)compositeNode);
        List associations = (List)compositeNode.getMetaData("BPMN.Associations");
        ProcessHandler.linkAssociations((Definitions)compositeNode.getMetaData("Definitions"), (NodeContainer)compositeNode, associations);
    }

    protected void applyAsync(Node node, boolean isAsync) {
        for (org.kie.api.definition.process.Node subNode : ((CompositeContextNode)node).getNodes()) {
            List incoming;
            if (!isAsync || (incoming = subNode.getIncomingConnections("DROOLS_DEFAULT")) == null) continue;
            for (Connection con : incoming) {
                if (!(con.getFrom() instanceof StartNode)) continue;
                ((Node)subNode).setMetaData("customAsync", (Object)Boolean.toString(isAsync));
                return;
            }
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

