/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.TaskHandler;
import org.jbpm.process.core.Work;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserTaskHandler
extends TaskHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new HumanTaskNode();
    }

    public Class<HumanTaskNode> generateNodeFor() {
        return HumanTaskNode.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Node currentNode = super.handleNode(node, element, uri, localName, parser);
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        Work work = humanTaskNode.getWork();
        work.setName("Human Task");
        this.setParameter(work, "Description", humanTaskNode.getIoSpecification().getDataInputAssociation());
        this.setParameter(work, "Comment", humanTaskNode.getIoSpecification().getDataInputAssociation());
        this.setParameter(work, "ActorId", humanTaskNode.getIoSpecification().getDataInputAssociation());
        this.setParameter(work, "GroupId", humanTaskNode.getIoSpecification().getDataInputAssociation());
        this.setParameter(work, "Priority", humanTaskNode.getIoSpecification().getDataInputAssociation());
        this.setParameter(work, "Skippable", humanTaskNode.getIoSpecification().getDataInputAssociation());
        this.setParameter(work, "Content", humanTaskNode.getIoSpecification().getDataInputAssociation());
        ArrayList<String> owners = new ArrayList<String>();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String owner;
            String nodeName = xmlNode.getNodeName();
            if (!"potentialOwner".equals(nodeName) || (owner = this.readPotentialOwner(xmlNode, humanTaskNode)) == null) continue;
            owners.add(owner);
        }
        if (owners.size() > 0) {
            Object owner = (String)owners.get(0);
            for (int i = 1; i < owners.size(); ++i) {
                owner = (String)owner + "," + (String)owners.get(i);
            }
            humanTaskNode.getWork().setParameter("ActorId", owner);
        }
        return currentNode;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        return super.end(uri, localName, parser);
    }

    protected String readPotentialOwner(org.w3c.dom.Node xmlNode, HumanTaskNode humanTaskNode) {
        org.w3c.dom.Node node = xmlNode.getFirstChild();
        if (node != null && (node = node.getFirstChild()) != null && (node = node.getFirstChild()) != null) {
            return node.getTextContent();
        }
        return null;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        HumanTaskNode humanTaskNode = (HumanTaskNode)node;
        this.writeNode("userTask", (Node)humanTaskNode, xmlDump, metaDataType);
        xmlDump.append(">" + EOL);
        this.writeExtensionElements((Node)humanTaskNode, xmlDump);
        this.writeIO(humanTaskNode.getIoSpecification(), xmlDump);
        this.writeMultiInstance(humanTaskNode.getMultiInstanceSpecification(), xmlDump);
        String ownerString = (String)humanTaskNode.getWork().getParameter("ActorId");
        if (ownerString != null) {
            String[] owners;
            for (String owner : owners = ownerString.split(",")) {
                xmlDump.append("      <potentialOwner>" + EOL + "        <resourceAssignmentExpression>" + EOL + "          <formalExpression>" + owner + "</formalExpression>" + EOL + "        </resourceAssignmentExpression>" + EOL + "      </potentialOwner>" + EOL);
            }
        }
        this.endNode("userTask", xmlDump);
    }
}

