/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.xml.sax.Attributes;

public class WorkItemNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by specific handlers");
    }

    public Class<WorkItemNode> generateNodeFor() {
        return WorkItemNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        WorkItemNode workItemNode = (WorkItemNode)node;
        String type = workItemNode.getWork().getName();
        if ("Manual Task".equals(type)) {
            this.writeNode("manualTask", (Node)workItemNode, xmlDump, metaDataType);
            xmlDump.append(">" + EOL);
            this.writeExtensionElements((Node)workItemNode, xmlDump);
            this.endNode("manualTask", xmlDump);
            return;
        }
        if ("Service Task".equals(type)) {
            this.writeNode("serviceTask", (Node)workItemNode, xmlDump, metaDataType);
            String impl = "Other";
            if (workItemNode.getWork().getParameter("implementation") != null) {
                impl = (String)workItemNode.getWork().getParameter("implementation");
            }
            xmlDump.append("operationRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_ServiceOperation\" implementation=\"" + impl + "\" >" + EOL);
            this.writeExtensionElements((Node)workItemNode, xmlDump);
            this.writeIO(workItemNode.getIoSpecification(), xmlDump);
            this.endNode("serviceTask", xmlDump);
            return;
        }
        if ("Send Task".equals(type)) {
            this.writeNode("sendTask", (Node)workItemNode, xmlDump, metaDataType);
            xmlDump.append("messageRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_Message\" implementation=\"Other\" >" + EOL);
            this.writeExtensionElements((Node)workItemNode, xmlDump);
            this.writeIO(workItemNode.getIoSpecification(), xmlDump);
            this.endNode("sendTask", xmlDump);
            return;
        }
        if ("Receive Task".equals(type)) {
            this.writeNode("receiveTask", (Node)workItemNode, xmlDump, metaDataType);
            String messageId = (String)workItemNode.getWork().getParameter("MessageId");
            xmlDump.append("messageRef=\"" + messageId + "\" implementation=\"Other\" >" + EOL);
            this.writeExtensionElements((Node)workItemNode, xmlDump);
            this.writeIO(workItemNode.getIoSpecification(), xmlDump);
            this.endNode("receiveTask", xmlDump);
            return;
        }
        this.writeNode("task", (Node)workItemNode, xmlDump, metaDataType);
        Object isForCompensationObject = workItemNode.getMetaData("isForCompensation");
        if (isForCompensationObject != null && ((Boolean)isForCompensationObject).booleanValue()) {
            xmlDump.append("isForCompensation=\"true\" ");
        }
        xmlDump.append("tns:taskName=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" >" + EOL);
        this.writeExtensionElements((Node)workItemNode, xmlDump);
        this.writeIO(workItemNode.getIoSpecification(), xmlDump);
        this.endNode("task", xmlDump);
    }
}

