/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskHandler
implements KogitoWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTaskHandler.class);
    private String resultVarName;

    public ServiceTaskHandler() {
        this("Result");
    }

    public ServiceTaskHandler(String resultVarName) {
        this.resultVarName = resultVarName;
    }

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        String service = (String)workItem.getParameter("Interface");
        String interfaceImplementationRef = (String)workItem.getParameter("interfaceImplementationRef");
        String operation = (String)workItem.getParameter("Operation");
        String parameterType = (String)workItem.getParameter("ParameterType");
        Object parameter = workItem.getParameter("Parameter");
        String[] services = new String[]{service, interfaceImplementationRef};
        Class<?> c = null;
        for (String serv : services) {
            try {
                c = Class.forName(serv);
                break;
            }
            catch (ClassNotFoundException cnfe) {
                if (serv.compareTo(services[services.length - 1]) != 0) continue;
                this.handleException(cnfe, service, interfaceImplementationRef, operation, parameterType, parameter);
            }
        }
        try {
            Object instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class[] classes = null;
            Object[] params = null;
            if (parameterType != null) {
                classes = new Class[]{Class.forName(parameterType)};
                params = new Object[]{parameter};
            }
            Method method = c.getMethod(operation, classes);
            Object result = method.invoke(instance, params);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(this.resultVarName, result);
            manager.completeWorkItem(workItem.getStringId(), results, new Policy[0]);
        }
        catch (Exception cnfe) {
            this.handleException(cnfe, service, interfaceImplementationRef, operation, parameterType, parameter);
        }
    }

    private void handleException(Throwable cause, String service, String interfaceImplementationRef, String operation, String paramType, Object param) {
        logger.debug("Handling exception {} inside service {} or {} and operation {} with param type {} and value {}", new Object[]{cause.getMessage(), service, interfaceImplementationRef, operation, paramType, param});
        Throwable realCause = cause instanceof InvocationTargetException ? cause.getCause() : cause;
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("Interface", service);
        info.put("InterfaceImplementationRef", interfaceImplementationRef);
        info.put("Operation", operation);
        info.put("ParameterType", paramType);
        info.put("Parameter", param);
        info.put("workItemHandlerType", this.getClass().getSimpleName());
        WorkItemHandlerRuntimeException wihRe = new WorkItemHandlerRuntimeException(realCause, info);
        wihRe.setStackTrace(realCause.getStackTrace());
        throw wihRe;
    }

    public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
    }
}

