/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.bpmn2.core.CorrelationSubscription;
import org.jbpm.bpmn2.core.Expression;
import org.jbpm.bpmn2.xml.HandlerUtil;
import org.jbpm.compiler.xml.Handler;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.core.BaseAbstractHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CorrelationSubscriptionHandler
extends BaseAbstractHandler
implements Handler {
    public Object start(String uri, String localName, Attributes attrs, Parser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String correlationSubscriptionPropertyId = attrs.getValue("id");
        String correlationSubscriptionPropertyName = attrs.getValue("name");
        String correlationSubscriptionRef = attrs.getValue("correlationKeyRef");
        CorrelationSubscription correlationSubscription = new CorrelationSubscription();
        correlationSubscription.setId(correlationSubscriptionPropertyId);
        correlationSubscription.setName(correlationSubscriptionPropertyName);
        correlationSubscription.setCorrelationKeyRef(correlationSubscriptionRef);
        RuleFlowProcess process = (RuleFlowProcess)parser.getParent();
        HandlerUtil.correlationSubscription(process).put(correlationSubscriptionPropertyId, correlationSubscription);
        return correlationSubscription;
    }

    public Object end(String uri, String localName, Parser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        CorrelationSubscription correlationSubscription = (CorrelationSubscription)parser.getCurrent();
        correlationSubscription.getPropertyExpressions().putAll(this.buildPropertyProcessBindings(element.getChildNodes(), parser));
        return null;
    }

    private Map<String, Expression> buildPropertyProcessBindings(NodeList childNodes, Parser parser) {
        HashMap<String, Expression> correlationKeys = new HashMap<String, Expression>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!"correlationPropertyBinding".equals(node.getNodeName())) continue;
            Element elementBinding = (Element)node;
            correlationKeys.put(elementBinding.getAttribute("correlationPropertyRef"), this.buildBindingExpression(elementBinding.getChildNodes(), parser));
        }
        return correlationKeys;
    }

    private Expression buildBindingExpression(NodeList childNodes, Parser parser) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!"dataPath".equals(node.getNodeName())) continue;
            Element expressionElement = (Element)node;
            Expression expression = new Expression();
            expression.setId(expressionElement.getAttribute("id"));
            expression.setLang(expressionElement.getAttribute("language"));
            expression.setScript(expressionElement.getTextContent());
            expression.setOutcomeType(HandlerUtil.definitions(parser).get(expressionElement.getAttribute("evaluatesToTypeRef")).getStructureRef());
            return expression;
        }
        throw new RuntimeException("message Path not found for correlation property " + parser.getCurrent());
    }

    public Class<?> generateNodeFor() {
        return CorrelationSubscription.class;
    }
}

