/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.flow.migration.MigrationPlanFile;
import org.jbpm.flow.migration.MigrationPlanFileProvider;
import org.jbpm.util.JbpmClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemMigrationPlanFileProvider
implements MigrationPlanFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemMigrationPlanFileProvider.class);
    public static final String EXPLODED_MIGRATION_PLAN_FOLDER = "META-INF/migration-plan/";
    public static final String MIGRATION_PLAN_FOLDER = "/META-INF/migration-plan/";
    private Set<URI> rootPaths;

    public FileSystemMigrationPlanFileProvider() {
        try {
            ArrayList<URL> url = Collections.list(JbpmClassLoaderUtil.findClassLoader().getResources(MIGRATION_PLAN_FOLDER));
            if (url.isEmpty()) {
                url = Collections.list(JbpmClassLoaderUtil.findClassLoader().getResources(EXPLODED_MIGRATION_PLAN_FOLDER));
            }
            this.rootPaths = url.stream().map(this::toURI).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error trying to get Migration Plan folder");
        }
    }

    private Optional<URI> toURI(URL e) {
        try {
            return Optional.of(e.toURI());
        }
        catch (URISyntaxException ex) {
            return Optional.empty();
        }
    }

    public FileSystemMigrationPlanFileProvider(URI rootPath) {
        this.rootPaths = Set.of(rootPath);
    }

    @Override
    public List<MigrationPlanFile> listMigrationPlanFiles(String ... extensions) {
        List<String> allowedExtensions = Arrays.asList(extensions);
        ArrayList<MigrationPlanFile> migrationPlanFiles = new ArrayList<MigrationPlanFile>();
        for (URI rootPath : this.rootPaths) {
            if ("jar".equals(rootPath.getScheme())) {
                migrationPlanFiles.addAll(this.walkInJarPaths(rootPath, allowedExtensions));
                continue;
            }
            migrationPlanFiles.addAll(this.walkingPaths(Path.of(rootPath), allowedExtensions));
        }
        return migrationPlanFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MigrationPlanFile> walkInJarPaths(URI baseURI, List<String> extensions) {
        LOGGER.debug("Searching Migration Plans in rootPath {}", (Object)baseURI);
        try (FileSystem fileSystem = FileSystems.newFileSystem(baseURI, Collections.emptyMap(), JbpmClassLoaderUtil.findClassLoader());){
            Path myPath = fileSystem.getPath(MIGRATION_PLAN_FOLDER, new String[0]);
            if (!Files.exists(myPath, new LinkOption[0])) {
                LOGGER.debug("There was not any migration plan found within jar {}", (Object)myPath);
                List<MigrationPlanFile> list2 = Collections.emptyList();
                return list2;
            }
            List<MigrationPlanFile> list = this.walkingPaths(myPath, extensions);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("There was a problem during migration plan execution", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<MigrationPlanFile> walkingPaths(Path basePath, List<String> allowedExtensions) {
        List<MigrationPlanFile> migrationPlans = new ArrayList<MigrationPlanFile>();
        if (!Files.exists(basePath, new LinkOption[0])) {
            LOGGER.debug("There was not any migration plan found in path {}", (Object)basePath);
            return Collections.emptyList();
        }
        try (Stream<Path> walk = Files.walk(basePath, new FileVisitOption[0]);){
            migrationPlans = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> this.isMigrationPlanFileExtension((Path)e, allowedExtensions)).map(this::toMigrationPlanFile).toList();
        }
        catch (IOException e2) {
            LOGGER.error("There was an error trying to search for migration plan in basePath {}", (Object)basePath, (Object)e2);
        }
        return migrationPlans;
    }

    private boolean isMigrationPlanFileExtension(final Path path, List<String> extensions) {
        Predicate<String> predicate = new Predicate<String>(){

            @Override
            public boolean test(String extension) {
                return path.toString().endsWith(extension);
            }
        };
        return extensions.stream().anyMatch(predicate);
    }

    private MigrationPlanFile toMigrationPlanFile(Path path) {
        try {
            return new MigrationPlanFile(path, Files.readAllBytes(path));
        }
        catch (IOException e) {
            LOGGER.error("There was an error trying to search for migration plan in basePath {}", (Throwable)e);
            return new MigrationPlanFile(path, new byte[0]);
        }
    }
}

