/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.migration;

import org.jbpm.flow.migration.MigrationPlanService;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerListener;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.Processes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardMigrationProcessInstanceMarshallerListener
implements ProcessInstanceMarshallerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardMigrationProcessInstanceMarshallerListener.class);
    private MigrationPlanService migrationPlanService = new MigrationPlanService();

    public void afterUnmarshallProcess(KogitoProcessRuntime runtime, KogitoWorkflowProcessInstance processInstance) {
        if (!this.migrationPlanService.hasMigrationPlan((Processes)runtime.getApplication().get(Processes.class), processInstance)) {
            if (!this.migrationPlanService.isEqualVersion((Processes)runtime.getApplication().get(Processes.class), processInstance)) {
                LOGGER.debug("Process State version and process container mismatch. Migrating process without plan.");
                RuleFlowProcessInstance ruleFlowProcessInstance = (RuleFlowProcessInstance)processInstance;
                ruleFlowProcessInstance.setProcess(ruleFlowProcessInstance.getProcess());
            }
            return;
        }
        LOGGER.debug("Migration processInstance state {}-{} and definition {}-{}", new Object[]{processInstance.getProcessId(), processInstance.getProcessVersion(), processInstance.getProcess().getId(), processInstance.getProcess().getVersion()});
        this.migrationPlanService.migrateProcessElement((Processes)runtime.getApplication().get(Processes.class), processInstance);
        runtime.getProcessEventSupport().fireOnMigration((KogitoProcessInstance)processInstance, runtime.getKieRuntime());
    }

    public void afterUnmarshallNode(KogitoProcessRuntime runtime, KogitoNodeInstance nodeInstance) {
        if (!this.migrationPlanService.hasMigrationPlan((Processes)runtime.getApplication().get(Processes.class), (KogitoWorkflowProcessInstance)nodeInstance.getProcessInstance())) {
            return;
        }
        LOGGER.debug("Migration nodeInstance {}", (Object)nodeInstance);
        this.migrationPlanService.migrateNodeElement((Processes)runtime.getApplication().get(Processes.class), nodeInstance);
    }
}

