/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.flow.migration.MigrationPlanFile;
import org.jbpm.flow.migration.MigrationPlanFileFormatException;
import org.jbpm.flow.migration.MigrationPlanFileProvider;
import org.jbpm.flow.migration.MigrationPlanFileReader;
import org.jbpm.flow.migration.model.MigrationPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationPlanProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationPlanProvider.class);
    private List<MigrationPlanFileReader> fileReaders = new ArrayList<MigrationPlanFileReader>();
    private List<MigrationPlanFileProvider> fileProviders = new ArrayList<MigrationPlanFileProvider>();

    public List<MigrationPlan> findMigrationPlans() {
        String[] extensions = (String[])this.fileReaders.stream().map(MigrationPlanFileReader::getFileExtension).toArray(String[]::new);
        ArrayList<MigrationPlanFile> migrationPlanFiles = new ArrayList<MigrationPlanFile>();
        for (MigrationPlanFileProvider provider : this.fileProviders) {
            migrationPlanFiles.addAll(provider.listMigrationPlanFiles(extensions));
        }
        ArrayList<MigrationPlan> migrationPlans = new ArrayList<MigrationPlan>();
        for (MigrationPlanFile mpf : migrationPlanFiles) {
            try {
                migrationPlans.add(this.readMigrationPlan(mpf));
            }
            catch (IOException e) {
                LOGGER.error("Error trying to read migration plan {}", (Object)mpf.getPath(), (Object)e);
            }
        }
        return migrationPlans;
    }

    private MigrationPlan readMigrationPlan(MigrationPlanFile mpf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(mpf.getContent());){
            for (MigrationPlanFileReader reader : this.fileReaders) {
                if (!reader.accept(mpf.getPath())) continue;
                MigrationPlan migrationPlan = reader.read(is);
                return migrationPlan;
            }
        }
        throw new MigrationPlanFileFormatException("Not file format reader found for " + mpf.getPath());
    }

    public static MigrationPlanProviderBuilder newMigrationPlanProviderBuilder() {
        return new MigrationPlanProviderBuilder();
    }

    public static class MigrationPlanProviderBuilder {
        private MigrationPlanProvider migrationPlanProvider = new MigrationPlanProvider();

        public MigrationPlanProviderBuilder withEnvironmentDefaults() {
            this.migrationPlanProvider.fileReaders.addAll(MigrationPlanFileReader.findMigrationPlanFileReaders());
            this.migrationPlanProvider.fileProviders.addAll(MigrationPlanFileProvider.findMigrationPlanFileProviders());
            return this;
        }

        public MigrationPlanProviderBuilder withMigrationPlanFileReader(MigrationPlanFileReader migrationPlanFileReader) {
            this.migrationPlanProvider.fileReaders.add(migrationPlanFileReader);
            return this;
        }

        public MigrationPlanProviderBuilder withMigrationPlanFileProvider(MigrationPlanFileProvider MigrationPlanFileProvider2) {
            this.migrationPlanProvider.fileProviders.add(MigrationPlanFileProvider2);
            return this;
        }

        public MigrationPlanProvider build() {
            return this.migrationPlanProvider;
        }
    }
}

