/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.function.Supplier;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.kie.api.runtime.KieRuntime;
import org.kie.dmn.api.core.DMNRuntime;

public class RuleSetNodeFactory
extends NodeFactory {
    public RuleSetNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
    }

    @Override
    protected Node createNode() {
        return new RuleSetNode();
    }

    protected RuleSetNode getRuleSetNode() {
        return (RuleSetNode)this.getNode();
    }

    public RuleSetNodeFactory name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public RuleSetNodeFactory ruleFlowGroup(String ruleFlowGroup, Supplier<KieRuntime> supplier) {
        this.getRuleSetNode().setRuleFlowGroup(ruleFlowGroup);
        this.getRuleSetNode().setLanguage("http://www.jboss.org/drools/rule");
        this.getRuleSetNode().setKieRuntime(supplier);
        return this;
    }

    public RuleSetNodeFactory dmnGroup(String namespace, String model, String decision, Supplier<DMNRuntime> supplier) {
        this.getRuleSetNode().setNamespace(namespace);
        this.getRuleSetNode().setModel(model);
        this.getRuleSetNode().setDecision(decision);
        this.getRuleSetNode().setLanguage("http://www.jboss.org/drools/dmn");
        this.getRuleSetNode().setDmnRuntime(supplier);
        return this;
    }

    public RuleSetNodeFactory timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getRuleSetNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }

    public RuleSetNodeFactory inMapping(String parameterName, String variableName) {
        this.getRuleSetNode().addInMapping(parameterName, variableName);
        return this;
    }

    public RuleSetNodeFactory outMapping(String parameterName, String variableName) {
        this.getRuleSetNode().addOutMapping(parameterName, variableName);
        return this;
    }
}

