/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.type;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.datatype.DataType;

public class EnumDataType
implements DataType {
    private static final long serialVersionUID = 4L;
    private String className;
    private transient Map<String, Object> valueMap;

    public EnumDataType() {
    }

    public EnumDataType(String className) {
        this.setClassName(className);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        return this.getValueMap(null).containsValue(value);
    }

    @Override
    public Object readValue(String value) {
        return this.getValueMap(null).get(value);
    }

    @Override
    public String writeValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public String getStringType() {
        return this.className == null ? "java.lang.Object" : this.className;
    }

    public Object[] getValues(ClassLoader classLoader) {
        return this.getValueMap(classLoader).values().toArray();
    }

    public Object[] getValues() {
        return this.getValues(null);
    }

    public String[] getValueNames(ClassLoader classLoader) {
        return this.getValueMap(classLoader).keySet().toArray(new String[0]);
    }

    public String[] getValueNames() {
        return this.getValueNames(null);
    }

    public Map<String, Object> getValueMap() {
        return this.getValueMap(null);
    }

    public Map<String, Object> getValueMap(ClassLoader classLoader) {
        if (this.valueMap == null) {
            try {
                Object[] values;
                Class<?> clazz;
                this.valueMap = new HashMap<String, Object>();
                if (this.className == null) {
                    return null;
                }
                Class<?> clazz2 = clazz = classLoader == null ? Class.forName(this.className) : Class.forName(this.className, true, classLoader);
                if (!clazz.isEnum()) {
                    return null;
                }
                for (Object value : values = (Object[])clazz.getMethod("values", null).invoke(clazz, null)) {
                    this.valueMap.put(value.toString(), value);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not find data type " + this.className);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("IllegalAccessException " + e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("InvocationTargetException " + e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("NoSuchMethodException " + e);
            }
        }
        return this.valueMap;
    }
}

