/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.impl.ContextContainerImpl;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.runtime.KieRuntime;
import org.kie.dmn.api.core.DMNRuntime;

public class RuleSetNode
extends StateBasedNode
implements ContextContainer {
    private static final long serialVersionUID = 510L;
    public static final String DRL_LANG = "http://www.jboss.org/drools/rule";
    public static final String DMN_LANG = "http://www.jboss.org/drools/dmn";
    private String language = "http://www.jboss.org/drools/rule";
    private ContextContainer contextContainer = new ContextContainerImpl();
    private String ruleFlowGroup;
    private String namespace;
    private String model;
    private String decision;
    private List<DataAssociation> inMapping = new LinkedList<DataAssociation>();
    private List<DataAssociation> outMapping = new LinkedList<DataAssociation>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Supplier<DMNRuntime> dmnRuntime;
    private Supplier<KieRuntime> kieRuntime;

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getDecision() {
        return this.decision;
    }

    public void setDecision(String decision) {
        this.decision = decision;
    }

    public Supplier<DMNRuntime> getDmnRuntime() {
        return this.dmnRuntime;
    }

    public void setDmnRuntime(Supplier<DMNRuntime> dmnRuntime) {
        this.dmnRuntime = dmnRuntime;
    }

    public Supplier<KieRuntime> getKieRuntime() {
        return this.kieRuntime;
    }

    public void setKieRuntime(Supplier<KieRuntime> kieRuntime) {
        this.kieRuntime = kieRuntime;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getFrom().getMetaData().get("UniqueId") + ", " + connection.getFrom().getName() + "] cannot have more than one outgoing connection!");
        }
    }

    public void addInMapping(String parameterName, String variableName) {
        this.inMapping.add(new DataAssociation(variableName, parameterName, null, null));
    }

    public void setInMappings(Map<String, String> inMapping) {
        this.inMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : inMapping.entrySet()) {
            this.addInMapping(entry.getKey(), entry.getValue());
        }
    }

    public String getInMapping(String parameterName) {
        return this.getInMappings().get(parameterName);
    }

    public Map<String, String> getInMappings() {
        HashMap<String, String> in = new HashMap<String, String>();
        for (DataAssociation a : this.inMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && a.getAssignments().size() != 0 || a.getTransformation() != null) continue;
            in.put(a.getTarget(), a.getSources().get(0));
        }
        return in;
    }

    public void addInAssociation(DataAssociation dataAssociation) {
        this.inMapping.add(dataAssociation);
    }

    public List<DataAssociation> getInAssociations() {
        return Collections.unmodifiableList(this.inMapping);
    }

    public void addOutMapping(String parameterName, String variableName) {
        this.outMapping.add(new DataAssociation(parameterName, variableName, null, null));
    }

    public void setOutMappings(Map<String, String> outMapping) {
        this.outMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : outMapping.entrySet()) {
            this.addOutMapping(entry.getKey(), entry.getValue());
        }
    }

    public String getOutMapping(String parameterName) {
        return this.getOutMappings().get(parameterName);
    }

    public Map<String, String> getOutMappings() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (DataAssociation a : this.outMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && a.getAssignments().size() != 0 || a.getTransformation() != null) continue;
            out.put(a.getSources().get(0), a.getTarget());
        }
        return out;
    }

    public void addOutAssociation(DataAssociation dataAssociation) {
        this.outMapping.add(dataAssociation);
    }

    public List<DataAssociation> getOutAssociations() {
        return Collections.unmodifiableList(this.outMapping);
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String param, Object value) {
        this.parameters.put(param, value);
    }

    public Object getParameter(String param) {
        return this.parameters.get(param);
    }

    public Object removeParameter(String param) {
        return this.parameters.remove(param);
    }

    public boolean isDMN() {
        return DMN_LANG.equals(this.language);
    }

    @Override
    public List<Context> getContexts(String contextType) {
        return this.contextContainer.getContexts(contextType);
    }

    @Override
    public void addContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.addContext(context);
    }

    @Override
    public Context getContext(String contextType, long id) {
        return this.contextContainer.getContext(contextType, id);
    }

    @Override
    public void setDefaultContext(Context context) {
        ((AbstractContext)context).setContextContainer(this);
        this.contextContainer.setDefaultContext(context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return this.contextContainer.getDefaultContext(contextType);
    }

    @Override
    public Context getContext(String contextId) {
        Context context = this.getDefaultContext(contextId);
        if (context != null) {
            return context;
        }
        return super.getContext(contextId);
    }
}

