/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.BoundaryEventNode;

public class BoundaryEventNodeFactory
extends EventNodeFactory {
    public static final String METHOD_ATTACHED_TO = "attachedTo";
    public static final String EVENT_TYPE_TIMER = "Timer";
    public static final String METADATA_ATTACHED_TO = "AttachedTo";
    public static final String METADATA_TIME_CYCLE = "TimeCycle";
    public static final String METADATA_LANGUAGE = "Language";
    public static final String METADATA_TIME_DURATION = "TimeDuration";
    public static final String METADATA_CANCEL_ACTIVITY = "CancelActivity";
    private NodeContainer nodeContainer;
    private String attachedToUniqueId;

    public BoundaryEventNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
        this.nodeContainer = nodeContainer;
    }

    protected BoundaryEventNode getBoundaryEventNode() {
        return (BoundaryEventNode)this.getNode();
    }

    @Override
    protected Node createNode() {
        return new BoundaryEventNode();
    }

    @Override
    public BoundaryEventNodeFactory name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public BoundaryEventNodeFactory variableName(String variableName) {
        super.variableName(variableName);
        return this;
    }

    @Override
    public BoundaryEventNodeFactory eventFilter(EventFilter eventFilter) {
        super.eventFilter(eventFilter);
        return this;
    }

    @Override
    public BoundaryEventNodeFactory eventTransformer(EventTransformer transformer) {
        super.eventTransformer(transformer);
        return this;
    }

    @Override
    public BoundaryEventNodeFactory scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public BoundaryEventNodeFactory metaData(String name, Object value) {
        super.metaData(name, value);
        return this;
    }

    public BoundaryEventNodeFactory attachedTo(long attachedToId) {
        this.attachedToUniqueId = (String)this.nodeContainer.getNode(attachedToId).getMetaData().get("UniqueId");
        this.getBoundaryEventNode().setAttachedToNodeId(this.attachedToUniqueId);
        this.getBoundaryEventNode().setMetaData(METADATA_ATTACHED_TO, this.attachedToUniqueId);
        return this;
    }

    public BoundaryEventNodeFactory attachedTo(String attachedToId) {
        this.attachedToUniqueId = attachedToId;
        this.getBoundaryEventNode().setAttachedToNodeId(this.attachedToUniqueId);
        this.getBoundaryEventNode().setMetaData(METADATA_ATTACHED_TO, this.attachedToUniqueId);
        return this;
    }

    @Override
    public BoundaryEventNodeFactory eventType(String eventType) {
        super.eventType(eventType);
        return this;
    }

    public BoundaryEventNodeFactory eventType(String eventTypePrefix, String eventTypeSurffix) {
        if (this.attachedToUniqueId == null) {
            throw new IllegalStateException("attachedTo() must be called before");
        }
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType(eventTypePrefix + "-" + this.attachedToUniqueId + "-" + eventTypeSurffix);
        super.eventFilter(filter);
        return this;
    }

    public BoundaryEventNodeFactory timeCycle(String timeCycle) {
        this.eventType(EVENT_TYPE_TIMER, timeCycle);
        return this.metaData(METADATA_TIME_CYCLE, timeCycle);
    }

    public BoundaryEventNodeFactory timeCycle(String timeCycle, String language) {
        this.eventType(EVENT_TYPE_TIMER, timeCycle);
        this.metaData(METADATA_TIME_CYCLE, timeCycle);
        return this.metaData(METADATA_LANGUAGE, language);
    }

    public BoundaryEventNodeFactory timeDuration(String timeDuration) {
        this.eventType(EVENT_TYPE_TIMER, timeDuration);
        return this.metaData(METADATA_TIME_DURATION, timeDuration);
    }

    public BoundaryEventNodeFactory cancelActivity(boolean cancelActivity) {
        return this.metaData(METADATA_CANCEL_ACTIVITY, cancelActivity);
    }
}

