/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.impl.workitem.Abort;
import org.jbpm.process.instance.impl.workitem.Complete;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.internal.runtime.Closeable;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.signal.SignalManager;

public class LightWorkItemManager
implements org.drools.core.process.instance.WorkItemManager {
    private Map<String, org.drools.core.process.instance.WorkItem> workItems = new ConcurrentHashMap<String, org.drools.core.process.instance.WorkItem>();
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();
    private final ProcessInstanceManager processInstanceManager;
    private final SignalManager signalManager;
    private final ProcessEventSupport eventSupport;
    private Complete completePhase = new Complete();
    private Abort abortPhase = new Abort();

    public LightWorkItemManager(ProcessInstanceManager processInstanceManager, SignalManager signalManager, ProcessEventSupport eventSupport) {
        this.processInstanceManager = processInstanceManager;
        this.signalManager = signalManager;
        this.eventSupport = eventSupport;
    }

    public void internalExecuteWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        ((WorkItemImpl)workItem).setId(UUID.randomUUID().toString());
        this.internalAddWorkItem(workItem);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new WorkItemHandlerNotFoundException(workItem.getName());
        }
        ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
        TransitionToActive transition = new TransitionToActive();
        this.eventSupport.fireBeforeWorkItemTransition(processInstance, (WorkItem)workItem, (Transition)transition, null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
        this.eventSupport.fireAfterWorkItemTransition(processInstance, (WorkItem)workItem, (Transition)transition, null);
    }

    public void internalAddWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        this.workItems.put(workItem.getId(), workItem);
    }

    public void internalAbortWorkItem(String id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            workItem.setCompleteDate(new Date());
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getId());
                throw new WorkItemHandlerNotFoundException(workItem.getName());
            }
            ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
            TransitionToAbort transition = new TransitionToAbort(Collections.emptyList());
            this.eventSupport.fireBeforeWorkItemTransition(processInstance, (WorkItem)workItem, (Transition)transition, null);
            handler.abortWorkItem((WorkItem)workItem, (WorkItemManager)this);
            workItem.setPhaseId("abort");
            workItem.setPhaseStatus("Aborted");
            this.eventSupport.fireAfterWorkItemTransition(processInstance, (WorkItem)workItem, (Transition)transition, null);
            this.workItems.remove(workItem.getId());
        }
    }

    public void retryWorkItem(String workItemId) {
        org.drools.core.process.instance.WorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(String workItemId, Map<String, Object> map) {
        org.drools.core.process.instance.WorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)this);
            } else {
                throw new WorkItemHandlerNotFoundException(workItem.getName());
            }
        }
    }

    public Set<org.drools.core.process.instance.WorkItem> getWorkItems() {
        return new HashSet<org.drools.core.process.instance.WorkItem>(this.workItems.values());
    }

    public org.drools.core.process.instance.WorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    public void completeWorkItem(String id, Map<String, Object> results, Policy<?> ... policies) {
        this.transitionWorkItem(id, new TransitionToComplete(results, Arrays.asList(policies)));
    }

    public void internalCompleteWorkItem(org.drools.core.process.instance.WorkItem workItem) {
        ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
        workItem.setState(2);
        workItem.setCompleteDate(new Date());
        if (processInstance != null) {
            processInstance.signalEvent("workItemCompleted", (Object)workItem);
        }
        this.workItems.remove(workItem.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transitionWorkItem(String id, Transition<?> transition) {
        org.drools.core.process.instance.WorkItem workItem = this.workItems.get(id);
        if (workItem == null) throw new WorkItemNotFoundException("Work Item (" + id + ") does not exist", id);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) throw new WorkItemHandlerNotFoundException(workItem.getName());
        ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
        this.eventSupport.fireBeforeWorkItemTransition(processInstance, (WorkItem)workItem, transition, null);
        try {
            handler.transitionToPhase((WorkItem)workItem, (WorkItemManager)this, transition);
        }
        catch (UnsupportedOperationException e) {
            workItem.setResults((Map)transition.data());
            workItem.setPhaseId("complete");
            workItem.setPhaseStatus("Completed");
            this.completePhase.apply((WorkItem)workItem, transition);
            this.internalCompleteWorkItem(workItem);
        }
        this.eventSupport.fireAfterWorkItemTransition(processInstance, (WorkItem)workItem, transition, null);
    }

    public void abortWorkItem(String id, Policy<?> ... policies) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            if (!workItem.enforce(policies)) {
                throw new NotAuthorizedException("Work item can be aborted as it does not fulfil policies (e.g. security)");
            }
            ProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceId());
            TransitionToAbort transition = new TransitionToAbort(Arrays.asList(policies));
            this.eventSupport.fireBeforeWorkItemTransition(processInstance, (WorkItem)workItem, (Transition)transition, null);
            workItem.setState(3);
            this.abortPhase.apply((WorkItem)workItem, transition);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            workItem.setPhaseId("abort");
            workItem.setPhaseStatus("Aborted");
            this.eventSupport.fireAfterWorkItemTransition(processInstance, (WorkItem)workItem, (Transition)transition, null);
            this.workItems.remove(id);
        }
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, String processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void dispose() {
        if (this.workItemHandlers != null) {
            for (Map.Entry<String, WorkItemHandler> handlerEntry : this.workItemHandlers.entrySet()) {
                if (!(handlerEntry.getValue() instanceof Closeable)) continue;
                ((Closeable)handlerEntry.getValue()).close();
            }
        }
    }

    public void retryWorkItem(String workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }

    private static class TransitionToComplete
    implements Transition<Map<String, Object>> {
        private Map<String, Object> data;
        private List<Policy<?>> policies;

        TransitionToComplete(Map<String, Object> data, List<Policy<?>> policies) {
            this.data = data;
            this.policies = policies;
        }

        public String phase() {
            return "complete";
        }

        public Map<String, Object> data() {
            return this.data;
        }

        public List<Policy<?>> policies() {
            return this.policies;
        }
    }

    private static class TransitionToAbort
    implements Transition<Void> {
        private List<Policy<?>> policies;

        TransitionToAbort(List<Policy<?>> policies) {
            this.policies = policies;
        }

        public String phase() {
            return "abort";
        }

        public Void data() {
            return null;
        }

        public List<Policy<?>> policies() {
            return this.policies;
        }
    }

    private static class TransitionToActive
    implements Transition<Void> {
        private TransitionToActive() {
        }

        public String phase() {
            return "active";
        }

        public Void data() {
            return null;
        }

        public List<Policy<?>> policies() {
            return Collections.emptyList();
        }
    }
}

