/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.kogito.Model;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.flexible.AdHocFragment;
import org.kie.kogito.process.flexible.ItemDescription;
import org.kie.kogito.process.flexible.Milestone;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.BaseWorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.ProcessInstanceWorkUnit;
import org.kie.kogito.uow.WorkUnit;

public abstract class AbstractProcessInstance<T extends Model>
implements ProcessInstance<T> {
    protected final T variables;
    protected final AbstractProcess<T> process;
    protected final ProcessRuntime rt;
    protected org.kie.api.runtime.process.ProcessInstance legacyProcessInstance;
    protected Integer status;
    protected String id;
    protected String businessKey;
    protected String description;
    protected ProcessError processError;
    protected Supplier<org.kie.api.runtime.process.ProcessInstance> reloadSupplier;
    protected CompletionEventListener completionEventListener = new CompletionEventListener();

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt) {
        this(process, variables, null, rt);
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, String businessKey, ProcessRuntime rt) {
        this.process = process;
        this.rt = rt;
        this.variables = variables;
        StringCorrelationKey correlationKey = null;
        if (businessKey != null && !businessKey.trim().isEmpty()) {
            correlationKey = new StringCorrelationKey(businessKey);
        }
        Map<String, Object> map = this.bind(variables);
        String processId = process.legacyProcess().getId();
        this.legacyProcessInstance = ((CorrelationAwareProcessRuntime)rt).createProcessInstance(processId, (CorrelationKey)correlationKey, map);
        this.id = this.legacyProcessInstance.getId();
        this.businessKey = ((WorkflowProcessInstance)this.legacyProcessInstance).getCorrelationKey();
        this.description = ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).getDescription();
        this.status = 0;
        if (correlationKey != null && process.instances.exists(this.id)) {
            throw new ProcessInstanceDuplicatedException(businessKey);
        }
    }

    public void internalSetProcessInstance(org.kie.api.runtime.process.ProcessInstance legacyProcessInstance) {
        if (this.legacyProcessInstance != null && this.status != 0) {
            throw new IllegalStateException("Impossible to override process instance that already exists");
        }
        this.legacyProcessInstance = legacyProcessInstance;
        this.status = legacyProcessInstance.getState();
        this.id = legacyProcessInstance.getId();
        this.businessKey = ((WorkflowProcessInstance)legacyProcessInstance).getCorrelationKey();
        this.description = ((WorkflowProcessInstanceImpl)legacyProcessInstance).getDescription();
        ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).setKnowledgeRuntime(((InternalProcessRuntime)this.rt).getInternalKieRuntime());
        ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).reconnect();
        ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).setMetaData("KogitoProcessInstance", this);
        ((WorkflowProcessInstance)legacyProcessInstance).addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        for (NodeInstance nodeInstance : ((WorkflowProcessInstance)legacyProcessInstance).getNodeInstances()) {
            if (!(nodeInstance instanceof WorkItemNodeInstance)) continue;
            ((WorkItemNodeInstance)nodeInstance).internalRegisterWorkItem();
        }
        this.unbind(this.variables, legacyProcessInstance.getVariables());
    }

    public org.kie.api.runtime.process.ProcessInstance internalGetProcessInstance() {
        return this.legacyProcessInstance;
    }

    public void internalRemoveProcessInstance(Supplier<org.kie.api.runtime.process.ProcessInstance> reloadSupplier) {
        this.reloadSupplier = reloadSupplier;
        this.status = this.legacyProcessInstance.getState();
        if (this.status == 5) {
            this.processError = this.buildProcessError();
        }
        this.legacyProcessInstance = null;
    }

    public void start() {
        this.start(null, null);
    }

    public void start(String trigger, String referenceId) {
        if (this.status != 0) {
            throw new IllegalStateException("Impossible to start process instance that already was started");
        }
        this.status = 1;
        ((WorkflowProcessInstance)this.legacyProcessInstance).addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        if (referenceId != null) {
            ((WorkflowProcessInstance)this.legacyProcessInstance).setReferenceId(referenceId);
        }
        org.kie.api.runtime.process.ProcessInstance processInstance = this.rt.startProcessInstance(this.id, trigger);
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).create(pi.id(), pi));
        this.unbind(this.variables, processInstance.getVariables());
        if (this.legacyProcessInstance != null) {
            this.status = this.legacyProcessInstance.getState();
        }
    }

    protected void addToUnitOfWork(Consumer<ProcessInstance<T>> action) {
        ((InternalProcessRuntime)this.rt).getUnitOfWorkManager().currentUnitOfWork().intercept((WorkUnit)new ProcessInstanceWorkUnit((ProcessInstance)this, action));
    }

    public void abort() {
        String pid = this.legacyProcessInstance().getId();
        this.unbind(this.variables, this.legacyProcessInstance().getVariables());
        this.rt.abortProcessInstance(pid);
        this.status = this.legacyProcessInstance.getState();
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).remove(pi.id()));
    }

    public <S> void send(Signal<S> signal) {
        if (signal.referenceId() != null) {
            ((WorkflowProcessInstance)this.legacyProcessInstance()).setReferenceId(signal.referenceId());
        }
        this.legacyProcessInstance().signalEvent(signal.channel(), signal.payload());
        this.removeOnFinish();
    }

    public Process<T> process() {
        return this.process;
    }

    public T variables() {
        return this.variables;
    }

    public int status() {
        return this.status;
    }

    public String id() {
        return this.id;
    }

    public String businessKey() {
        return this.businessKey;
    }

    public String description() {
        return this.description;
    }

    public Date startDate() {
        return this.legacyProcessInstance != null && this.legacyProcessInstance instanceof WorkflowProcessInstanceImpl ? ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).getStartDate() : null;
    }

    public void updateVariables(T updates) {
        Map<String, Object> map = this.bind(updates);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            ((WorkflowProcessInstance)this.legacyProcessInstance()).setVariable(entry.getKey(), entry.getValue());
        }
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
    }

    public Optional<ProcessError> error() {
        if (this.status == 5) {
            return Optional.of(this.processError != null ? this.processError : this.buildProcessError());
        }
        return Optional.empty();
    }

    public void startFrom(String nodeId) {
        this.startFrom(nodeId, null);
    }

    public void startFrom(String nodeId, String referenceId) {
        ((WorkflowProcessInstance)this.legacyProcessInstance).setStartDate(new Date());
        ((WorkflowProcessInstance)this.legacyProcessInstance).setState(1);
        ((WorkflowProcessInstance)this.legacyProcessInstance).addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        if (referenceId != null) {
            ((WorkflowProcessInstance)this.legacyProcessInstance).setReferenceId(referenceId);
        }
        this.triggerNode(nodeId);
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        this.unbind(this.variables, this.legacyProcessInstance.getVariables());
        if (this.legacyProcessInstance != null) {
            this.status = this.legacyProcessInstance.getState();
        }
    }

    public void triggerNode(String nodeId) {
        Node node;
        WorkflowProcessInstanceImpl wfpi = (WorkflowProcessInstanceImpl)this.legacyProcessInstance();
        RuleFlowProcess rfp = (RuleFlowProcess)wfpi.getProcess();
        Node parentNode = rfp.getParentNode((node = rfp.getNodesRecursively().stream().filter(ni -> nodeId.equals(ni.getMetaData().get("UniqueId"))).findFirst().orElseThrow(() -> new NodeNotFoundException(this.id, nodeId))).getId());
        WorkflowProcessInstanceImpl nodeInstanceContainerNode = parentNode == null ? wfpi : (NodeInstanceContainer)((Object)wfpi.getNodeInstance(parentNode));
        nodeInstanceContainerNode.getNodeInstance(node).trigger(null, "DROOLS_DEFAULT");
    }

    public void cancelNodeInstance(String nodeInstanceId) {
        org.jbpm.workflow.instance.NodeInstance nodeInstance = ((WorkflowProcessInstanceImpl)this.legacyProcessInstance()).getNodeInstances(true).stream().filter(ni -> ni.getId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
        ((NodeInstanceImpl)nodeInstance).cancel();
        this.removeOnFinish();
    }

    public void retriggerNodeInstance(String nodeInstanceId) {
        org.jbpm.workflow.instance.NodeInstance nodeInstance = ((WorkflowProcessInstanceImpl)this.legacyProcessInstance()).getNodeInstances(true).stream().filter(ni -> ni.getId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
        ((NodeInstanceImpl)nodeInstance).retrigger(true);
        this.removeOnFinish();
    }

    protected org.kie.api.runtime.process.ProcessInstance legacyProcessInstance() {
        if (this.legacyProcessInstance == null) {
            this.legacyProcessInstance = this.reloadSupplier.get();
            if (this.legacyProcessInstance == null) {
                throw new ProcessInstanceNotFoundException(this.id);
            }
        }
        return this.legacyProcessInstance;
    }

    public WorkItem workItem(String workItemId, Policy<?> ... policies) {
        WorkItemNodeInstance workItemInstance = (WorkItemNodeInstance)((WorkflowProcessInstanceImpl)this.legacyProcessInstance()).getNodeInstances(true).stream().filter(ni -> ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItemId().equals(workItemId) && ((WorkItemNodeInstance)ni).getWorkItem().enforce(policies)).findFirst().orElseThrow(() -> new WorkItemNotFoundException("Work item with id " + workItemId + " was not found in process instance " + this.id(), workItemId));
        return new BaseWorkItem(workItemInstance.getId(), workItemInstance.getWorkItem().getId(), workItemInstance.getWorkItem().getParameters().getOrDefault("TaskName", workItemInstance.getNodeName()), workItemInstance.getWorkItem().getState(), workItemInstance.getWorkItem().getPhaseId(), workItemInstance.getWorkItem().getPhaseStatus(), workItemInstance.getWorkItem().getParameters(), workItemInstance.getWorkItem().getResults());
    }

    public List<WorkItem> workItems(Policy<?> ... policies) {
        return ((WorkflowProcessInstanceImpl)this.legacyProcessInstance()).getNodeInstances(true).stream().filter(ni -> ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItem().enforce(policies)).map(ni -> new BaseWorkItem(ni.getId(), ((WorkItemNodeInstance)ni).getWorkItemId(), ((WorkItemNodeInstance)ni).getWorkItem().getParameters().getOrDefault("TaskName", ni.getNodeName()), ((WorkItemNodeInstance)ni).getWorkItem().getState(), ((WorkItemNodeInstance)ni).getWorkItem().getPhaseId(), ((WorkItemNodeInstance)ni).getWorkItem().getPhaseStatus(), ((WorkItemNodeInstance)ni).getWorkItem().getParameters(), ((WorkItemNodeInstance)ni).getWorkItem().getResults())).collect(Collectors.toList());
    }

    public void completeWorkItem(String id, Map<String, Object> variables, Policy<?> ... policies) {
        this.rt.getWorkItemManager().completeWorkItem(id, variables, policies);
        this.removeOnFinish();
    }

    public void abortWorkItem(String id, Policy<?> ... policies) {
        this.rt.getWorkItemManager().abortWorkItem(id, policies);
        this.removeOnFinish();
    }

    public void transitionWorkItem(String id, Transition<?> transition) {
        this.rt.getWorkItemManager().transitionWorkItem(id, transition);
        this.removeOnFinish();
    }

    public Set<EventDescription<?>> events() {
        return this.legacyProcessInstance().getEventDescriptions();
    }

    public Collection<Milestone> milestones() {
        return this.getNodes(this.getProcessNodeContainer(), MilestoneNode.class).map(n -> {
            String uid = (String)n.getMetaData().get("UniqueId");
            return new Milestone.Builder(uid).withName(n.getName()).withStatus(this.getStatus(uid)).withCondition(n.getConstraint()).build();
        }).collect(Collectors.toList());
    }

    public Collection<AdHocFragment> adHocFragments() {
        return this.getAdHocFragments(this.getProcessNodeContainer()).collect(Collectors.toList());
    }

    private Stream<AdHocFragment> getAdHocFragments(NodeContainer container) {
        if (container == null || container.getNodes() == null) {
            return Stream.empty();
        }
        return Stream.of(container.getNodes()).filter(n -> !(n instanceof StartNode) && !(n instanceof BoundaryEventNode)).filter(n -> n.getIncomingConnections().isEmpty()).map(this::buildAdHocFragment);
    }

    private AdHocFragment buildAdHocFragment(Node node) {
        return new AdHocFragment.Builder(node.getClass()).withName(node.getName()).withAutoStart(Boolean.parseBoolean((String)node.getMetaData().get("customAutoStart"))).build();
    }

    private NodeContainer getProcessNodeContainer() {
        if (!(this.legacyProcessInstance instanceof RuleFlowProcessInstance)) {
            return null;
        }
        NodeInstanceContainer processInstance = (NodeInstanceContainer)this.legacyProcessInstance;
        return processInstance.getNodeContainer();
    }

    private <N extends Node> Stream<N> getNodes(NodeContainer container, Class<N> nodeClass) {
        if (container == null) {
            return Stream.empty();
        }
        return Stream.of(container.getNodes()).filter(nodeClass::isInstance).map(nodeClass::cast);
    }

    private ItemDescription.Status getStatus(String uid) {
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)this.legacyProcessInstance;
        if (processInstance.getCompletedNodeIds().contains(uid)) {
            return ItemDescription.Status.COMPLETED;
        }
        if (processInstance.getActiveNodeIds().contains(uid)) {
            return ItemDescription.Status.ACTIVE;
        }
        return ItemDescription.Status.AVAILABLE;
    }

    protected void removeOnFinish() {
        if (this.legacyProcessInstance.getState() != 1 && this.legacyProcessInstance.getState() != 5) {
            ((WorkflowProcessInstance)this.legacyProcessInstance).removeEventListener("processInstanceCompleted:" + this.legacyProcessInstance.getId(), this.completionEventListener, false);
            this.status = this.legacyProcessInstance.getState();
            this.id = this.legacyProcessInstance.getId();
            this.businessKey = ((WorkflowProcessInstance)this.legacyProcessInstance).getCorrelationKey();
            this.description = ((WorkflowProcessInstanceImpl)this.legacyProcessInstance).getDescription();
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).remove(pi.id()));
        } else {
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        }
        this.unbind(this.variables, this.legacyProcessInstance().getVariables());
        this.status = this.legacyProcessInstance.getState();
    }

    protected Map<String, Object> bind(T variables) {
        HashMap<String, Object> vmap = new HashMap<String, Object>();
        if (variables == null) {
            return vmap;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = null;
                v = f.get(variables);
                vmap.put(f.getName(), v);
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
        return vmap;
    }

    protected void unbind(T variables, Map<String, Object> vmap) {
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                f.set(variables, vmap.get(f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcessInstance other = (AbstractProcessInstance)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    protected ProcessError buildProcessError() {
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)this.legacyProcessInstance();
        final String errorMessage = pi.getErrorMessage();
        final String nodeInError = pi.getNodeIdInError();
        return new ProcessError(){

            public String failedNodeId() {
                return nodeInError;
            }

            public String errorMessage() {
                return errorMessage;
            }

            public void retrigger() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.legacyProcessInstance();
                org.jbpm.workflow.instance.NodeInstance ni = pInstance.getNodeInstanceByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorMessage(null);
                ni.trigger(null, "DROOLS_DEFAULT");
                AbstractProcessInstance.this.removeOnFinish();
            }

            public void skip() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.legacyProcessInstance();
                org.jbpm.workflow.instance.NodeInstance ni = pInstance.getNodeInstanceByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorMessage(null);
                ((NodeInstanceImpl)ni).triggerCompleted("DROOLS_DEFAULT", true);
                AbstractProcessInstance.this.removeOnFinish();
            }
        };
    }

    private class StringCorrelationKey
    implements CorrelationKey {
        private final String correlationKey;

        public StringCorrelationKey(String correlationKey) {
            this.correlationKey = correlationKey;
        }

        public String getName() {
            return this.correlationKey;
        }

        public List<CorrelationProperty<?>> getProperties() {
            return Collections.emptyList();
        }

        public String toExternalForm() {
            return this.correlationKey;
        }
    }

    private class CompletionEventListener
    implements EventListener {
        private CompletionEventListener() {
        }

        public void signalEvent(String type, Object event) {
            AbstractProcessInstance.this.removeOnFinish();
        }

        public String[] getEventTypes() {
            return new String[]{"processInstanceCompleted:" + AbstractProcessInstance.this.legacyProcessInstance.getId()};
        }
    }
}

