/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.process.core.validation.impl.ProcessValidationErrorImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.services.time.impl.CronExpression;
import org.mvel2.ErrorDetail;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleFlowProcessValidator
implements ProcessValidator {
    public static final String ASSOCIATIONS = "BPMN.Associations";
    private static RuleFlowProcessValidator instance;
    private static final Logger logger;

    private RuleFlowProcessValidator() {
    }

    public static RuleFlowProcessValidator getInstance() {
        if (instance == null) {
            instance = new RuleFlowProcessValidator();
        }
        return instance;
    }

    public ProcessValidationError[] validateProcess(RuleFlowProcess process) {
        ArrayList<ProcessValidationError> errors = new ArrayList<ProcessValidationError>();
        if (process.getName() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no id."));
        }
        if (process.getStartNodes().isEmpty() && !process.isDynamic()) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        if (process.getEndNodes().isEmpty() && !process.isDynamic()) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no end node."));
        }
        this.validateNodes(process.getNodes(), errors, process);
        this.validateVariables(errors, process);
        this.checkAllNodesConnectedToStart(process, process.isDynamic(), errors, process);
        return errors.toArray(new ProcessValidationError[errors.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void validateNodes(Node[] nodes, List<ProcessValidationError> errors, RuleFlowProcess process) {
        String isForCompensation = "isForCompensation";
        for (int i = 0; i < nodes.length; ++i) {
            Object compensationObj;
            Object n;
            Node node = nodes[i];
            if (node instanceof StartNode) {
                StartNode startNode = (StartNode)node;
                if (startNode.getTo() == null) {
                    this.addErrorMessage(process, node, errors, "Start has no outgoing connection.");
                }
                if (startNode.getTimer() == null) continue;
                this.validateTimer(startNode.getTimer(), node, process, errors);
                continue;
            }
            if (node instanceof EndNode) {
                EndNode endNode = (EndNode)node;
                if (endNode.getFrom() == null) {
                    this.addErrorMessage(process, node, errors, "End has no incoming connection.");
                }
                this.validateCompensationIntermediateOrEndEvent(endNode, process, errors);
                continue;
            }
            if (node instanceof RuleSetNode) {
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (ruleSetNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "RuleSet has no incoming connection.");
                }
                if (ruleSetNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "RuleSet has no outgoing connection.");
                }
                String language = ruleSetNode.getLanguage();
                RuleSetNode.RuleType ruleType = ruleSetNode.getRuleType();
                if ("http://www.jboss.org/drools/rule".equals(language)) {
                    String ruleFlowGroup = ruleType.getName();
                    if (ruleFlowGroup == null || "".equals(ruleFlowGroup)) {
                        this.addErrorMessage(process, node, errors, "RuleSet (DRL) has no ruleflow-group.");
                    }
                } else if ("http://www.jboss.org/drools/rule-unit".equals(language)) {
                    String unit = ruleType.getName();
                    if (unit == null || "".equals(unit)) {
                        this.addErrorMessage(process, node, errors, "RuleSet (Rule Unit) has no ruleflow-group.");
                    }
                } else if ("http://www.jboss.org/drools/dmn".equals(language)) {
                    String model;
                    RuleSetNode.RuleType.Decision decision = (RuleSetNode.RuleType.Decision)ruleType;
                    String namespace = decision.getNamespace();
                    if (namespace == null || "".equals(namespace)) {
                        this.addErrorMessage(process, node, errors, "RuleSet (DMN) has no namespace.");
                    }
                    if ((model = decision.getModel()) == null || "".equals(model)) {
                        this.addErrorMessage(process, node, errors, "RuleSet (DMN) has no model.");
                    }
                } else {
                    this.addErrorMessage(process, node, errors, "Unsupported rule language '" + language + "'");
                }
                if (ruleSetNode.getTimers() == null) continue;
                for (Timer timer : ruleSetNode.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof Split) {
                Split split = (Split)node;
                if (split.getType() == 0) {
                    this.addErrorMessage(process, node, errors, "Split has no type.");
                }
                if (split.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Split has no incoming connection.");
                }
                if (split.getDefaultOutgoingConnections().size() < 2) {
                    this.addErrorMessage(process, node, errors, "Split does not have more than one outgoing connection: " + split.getOutgoingConnections().size() + ".");
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    if ((split.getConstraint(connection) != null || split.isDefault(connection)) && (split.isDefault(connection) || split.getConstraint(connection).getConstraint() != null && split.getConstraint(connection).getConstraint().trim().length() != 0)) continue;
                    this.addErrorMessage(process, node, errors, "Split does not have a constraint for " + connection.toString() + ".");
                }
                continue;
            }
            if (node instanceof Join) {
                Join join = (Join)node;
                if (join.getType() == 0) {
                    this.addErrorMessage(process, node, errors, "Join has no type.");
                }
                if (join.getDefaultIncomingConnections().size() < 2) {
                    this.addErrorMessage(process, node, errors, "Join does not have more than one incoming connection: " + join.getIncomingConnections().size() + ".");
                }
                if (join.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Join has no outgoing connection.");
                }
                if (join.getType() != 4 || ((String)(n = join.getN())).startsWith("#{") && ((String)n).endsWith("}")) continue;
                try {
                    new Integer((String)n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.addErrorMessage(process, node, errors, "Join has illegal n value: " + (String)n);
                }
                continue;
            }
            if (node instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)node;
                if (milestone.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Milestone has no incoming connection.");
                }
                if (milestone.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Milestone has no outgoing connection.");
                }
                if (milestone.getConstraint() == null) {
                    this.addErrorMessage(process, node, errors, "Milestone has no constraint.");
                }
                if (milestone.getTimers() == null) continue;
                n = milestone.getTimers().keySet().iterator();
                while (n.hasNext()) {
                    Timer timer = (Timer)n.next();
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                if (stateNode.getDefaultIncomingConnections().size() != 0 || this.acceptsNoIncomingConnections(node)) continue;
                this.addErrorMessage(process, node, errors, "State has no incoming connection");
                continue;
            }
            if (node instanceof SubProcessNode) {
                SubProcessNode subProcess = (SubProcessNode)node;
                if (subProcess.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "SubProcess has no incoming connection.");
                }
                if (!(subProcess.getTo() != null || this.acceptsNoOutgoingConnections(node) || (compensationObj = subProcess.getMetaData(isForCompensation)) != null && ((Boolean)compensationObj).booleanValue())) {
                    this.addErrorMessage(process, node, errors, "SubProcess has no outgoing connection.");
                }
                if (subProcess.getProcessId() == null && subProcess.getProcessName() == null) {
                    this.addErrorMessage(process, node, errors, "SubProcess has no process id.");
                }
                if (subProcess.getTimers() != null) {
                    compensationObj = subProcess.getTimers().keySet().iterator();
                    while (compensationObj.hasNext()) {
                        Timer timer = (Timer)compensationObj.next();
                        this.validateTimer(timer, node, process, errors);
                    }
                }
                if (subProcess.isIndependent() || subProcess.isWaitForCompletion()) continue;
                this.addErrorMessage(process, node, errors, "SubProcess you can only set independent to 'false' only when 'Wait for completion' is set to true.");
                continue;
            }
            if (node instanceof ActionNode) {
                ActionNode actionNode = (ActionNode)node;
                if (actionNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Action has no incoming connection.");
                }
                if (!(actionNode.getTo() != null || this.acceptsNoOutgoingConnections(node) || (compensationObj = actionNode.getMetaData(isForCompensation)) != null && ((Boolean)compensationObj).booleanValue())) {
                    this.addErrorMessage(process, node, errors, "Action has no outgoing connection.");
                }
                if (actionNode.getAction() == null) {
                    this.addErrorMessage(process, node, errors, "Action has no action.");
                    continue;
                }
                if (!(actionNode.getAction() instanceof DroolsConsequenceAction)) continue;
                DroolsConsequenceAction droolsAction = (DroolsConsequenceAction)actionNode.getAction();
                String string = droolsAction.getConsequence();
                if (string == null) {
                    this.addErrorMessage(process, node, errors, "Action has empty action.");
                } else if ("mvel".equals(droolsAction.getDialect())) {
                    try {
                        ParserContext parserContext = new ParserContext();
                        ExpressionCompiler compiler = new ExpressionCompiler(string, parserContext);
                        compiler.setVerifying(true);
                        compiler.compile();
                        List mvelErrors = parserContext.getErrorList();
                        if (mvelErrors != null) {
                            for (ErrorDetail error : mvelErrors) {
                                this.addErrorMessage(process, node, errors, "Action has invalid action: " + error.getMessage() + ".");
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.addErrorMessage(process, node, errors, "Action has invalid action: " + t.getMessage() + ".");
                    }
                }
                this.validateCompensationIntermediateOrEndEvent(actionNode, process, errors);
                continue;
            }
            if (node instanceof WorkItemNode) {
                WorkItemNode workItemNode = (WorkItemNode)node;
                if (workItemNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Task has no incoming connection.");
                }
                if (!(workItemNode.getTo() != null || this.acceptsNoOutgoingConnections(node) || (compensationObj = workItemNode.getMetaData(isForCompensation)) != null && ((Boolean)compensationObj).booleanValue())) {
                    this.addErrorMessage(process, node, errors, "Task has no outgoing connection.");
                }
                if (workItemNode.getWork() == null) {
                    this.addErrorMessage(process, node, errors, "Task has no work specified.");
                } else {
                    Work work = workItemNode.getWork();
                    if (work.getName() == null || work.getName().trim().length() == 0) {
                        this.addErrorMessage(process, node, errors, "Task has no task type.");
                    }
                }
                if (workItemNode.getTimers() == null) continue;
                for (Timer timer : workItemNode.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof ForEachNode) {
                List<Node> start;
                String string;
                ForEachNode forEachNode = (ForEachNode)node;
                String variableName = forEachNode.getVariableName();
                if (variableName == null || "".equals(variableName)) {
                    this.addErrorMessage(process, node, errors, "ForEach has no variable name");
                }
                if ((string = forEachNode.getCollectionExpression()) == null || "".equals(string)) {
                    this.addErrorMessage(process, node, errors, "ForEach has no collection expression");
                }
                if (forEachNode.getDefaultIncomingConnections().size() == 0 && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "ForEach has no incoming connection");
                }
                if (forEachNode.getDefaultOutgoingConnections().size() == 0 && !this.acceptsNoOutgoingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "ForEach has no outgoing connection");
                }
                if ((start = RuleFlowProcess.getStartNodes(forEachNode.getNodes())) != null) {
                    for (Node s : start) {
                        if ((((StartNode)s).getTriggers() == null || ((StartNode)s).getTriggers().isEmpty()) && ((StartNode)s).getTimer() == null) continue;
                        this.addErrorMessage(process, node, errors, "MultiInstance subprocess can only have none start event.");
                    }
                }
                this.validateNodes(forEachNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof DynamicNode) {
                DynamicNode dynamicNode = (DynamicNode)node;
                if (dynamicNode.getDefaultIncomingConnections().size() == 0 && !this.acceptsNoIncomingConnections(dynamicNode)) {
                    this.addErrorMessage(process, node, errors, "Dynamic has no incoming connection");
                }
                if (dynamicNode.getDefaultOutgoingConnections().size() == 0 && !this.acceptsNoOutgoingConnections(dynamicNode)) {
                    this.addErrorMessage(process, node, errors, "Dynamic has no outgoing connection");
                }
                if ("".equals(dynamicNode.getCompletionExpression()) && !dynamicNode.isAutoComplete()) {
                    this.addErrorMessage(process, node, errors, "Dynamic has no completion condition set");
                }
                this.validateNodes(dynamicNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof CompositeNode) {
                CompositeNode compositeNode = (CompositeNode)node;
                for (Map.Entry entry : compositeNode.getLinkedIncomingNodes().entrySet()) {
                    if (compositeNode.getIncomingConnections((String)entry.getKey()).size() == 0 && !this.acceptsNoIncomingConnections(node)) {
                        this.addErrorMessage(process, node, errors, "Composite has no incoming connection for type " + (String)entry.getKey());
                    }
                    if (((CompositeNode.NodeAndType)entry.getValue()).getNode() != null || this.acceptsNoOutgoingConnections(node)) continue;
                    this.addErrorMessage(process, node, errors, "Composite has invalid linked incoming node for type " + (String)entry.getKey());
                }
                for (Map.Entry<String, CompositeNode.NodeAndType> entry : compositeNode.getLinkedOutgoingNodes().entrySet()) {
                    if (compositeNode.getOutgoingConnections(entry.getKey()).size() == 0) {
                        this.addErrorMessage(process, node, errors, "Composite has no outgoing connection for type " + entry.getKey());
                    }
                    if (entry.getValue().getNode() != null) continue;
                    this.addErrorMessage(process, node, errors, "Composite has invalid linked outgoing node for type " + entry.getKey());
                }
                if (compositeNode.getLinkedIncomingNodes().values().size() < 1) {
                    boolean foundStartNode = false;
                    for (Node internalNode : compositeNode.getNodes()) {
                        if (!(internalNode instanceof StartNode)) continue;
                        foundStartNode = true;
                    }
                    if (!foundStartNode) {
                        this.addErrorMessage(process, node, errors, "Composite has no start node defined.");
                    }
                }
                if (compositeNode instanceof EventSubProcessNode) {
                    if (compositeNode.getIncomingConnections().size() > 0) {
                        this.addErrorMessage(process, node, errors, "Event subprocess is not allowed to have any incoming connections.");
                    }
                    if (compositeNode.getOutgoingConnections().size() > 0) {
                        this.addErrorMessage(process, node, errors, "Event subprocess is not allowed to have any outgoing connections.");
                    }
                    Node[] eventSubProcessNodes = compositeNode.getNodes();
                    boolean bl = false;
                    for (int j = 0; j < eventSubProcessNodes.length; ++j) {
                        void var9_23;
                        if (!(eventSubProcessNodes[j] instanceof StartNode)) continue;
                        StartNode startNode = (StartNode)eventSubProcessNodes[j];
                        if (++var9_23 == 2) {
                            this.addErrorMessage(process, compositeNode, errors, "Event subprocess is not allowed to have more than one start node.");
                        }
                        if (startNode.getTriggers() != null && !startNode.getTriggers().isEmpty()) continue;
                        this.addErrorMessage(process, startNode, errors, "Start in Event SubProcess '" + compositeNode.getName() + "' [" + compositeNode.getId() + "] must contain a trigger (event definition).");
                    }
                } else {
                    List<Node> list;
                    Boolean isForCompensationObject = (Boolean)compositeNode.getMetaData("isForCompensation");
                    if (compositeNode.getIncomingConnections().size() == 0 && !Boolean.TRUE.equals(isForCompensationObject)) {
                        this.addErrorMessage(process, node, errors, "Embedded subprocess does not have incoming connection.");
                    }
                    if (compositeNode.getOutgoingConnections().size() == 0 && !Boolean.TRUE.equals(isForCompensationObject)) {
                        this.addErrorMessage(process, node, errors, "Embedded subprocess does not have outgoing connection.");
                    }
                    if ((list = RuleFlowProcess.getStartNodes(compositeNode.getNodes())) != null) {
                        for (Node s : list) {
                            if ((((StartNode)s).getTriggers() == null || ((StartNode)s).getTriggers().isEmpty()) && ((StartNode)s).getTimer() == null) continue;
                            this.addErrorMessage(process, node, errors, "Embedded subprocess can only have none start event.");
                        }
                    }
                }
                if (compositeNode.getTimers() != null) {
                    for (Timer timer : compositeNode.getTimers().keySet()) {
                        this.validateTimer(timer, node, process, errors);
                    }
                }
                this.validateNodes(compositeNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof EventNode) {
                boolean bl;
                EventNode eventNode = (EventNode)node;
                if (eventNode.getEventFilters().size() == 0) {
                    this.addErrorMessage(process, node, errors, "Event should specify an event type");
                }
                if (eventNode.getDefaultOutgoingConnections().size() == 0) {
                    this.addErrorMessage(process, node, errors, "Event has no outgoing connection");
                    continue;
                }
                List<EventFilter> eventFilters = eventNode.getEventFilters();
                boolean bl2 = false;
                for (EventFilter eventFilter : eventFilters) {
                    if (!((EventTypeFilter)eventFilter).getType().startsWith("Compensation")) continue;
                    bl = true;
                    break;
                }
                if (!bl || !(eventNode instanceof BoundaryEventNode)) continue;
                Connection connection = eventNode.getDefaultOutgoingConnections().get(0);
                Boolean isAssociation = (Boolean)connection.getMetaData().get("association");
                if (isAssociation == null) {
                    isAssociation = false;
                }
                if (eventNode.getDefaultOutgoingConnections().size() == 1 && connection != null && isAssociation.booleanValue()) continue;
                this.addErrorMessage(process, node, errors, "Compensation Boundary Event is only allowed to have 1 association to 1 compensation activity.");
                continue;
            }
            if (node instanceof FaultNode) {
                FaultNode faultNode = (FaultNode)node;
                if (faultNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Fault has no incoming connection.");
                }
                if (faultNode.getFaultName() != null) continue;
                this.addErrorMessage(process, node, errors, "Fault has no fault name.");
                continue;
            }
            if (node instanceof TimerNode) {
                TimerNode timerNode = (TimerNode)node;
                if (timerNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Timer has no incoming connection.");
                }
                if (timerNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    this.addErrorMessage(process, node, errors, "Timer has no outgoing connection.");
                }
                if (timerNode.getTimer() == null) {
                    this.addErrorMessage(process, node, errors, "Timer has no timer specified.");
                    continue;
                }
                this.validateTimer(timerNode.getTimer(), node, process, errors);
                continue;
            }
            if (node instanceof CatchLinkNode || node instanceof ThrowLinkNode) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Unknown node type '" + node.getClass().getName() + "'"));
        }
    }

    private void checkAllNodesConnectedToStart(NodeContainer container, boolean isDynamic, List<ProcessValidationError> errors, RuleFlowProcess process) {
        HashMap<Node, Boolean> processNodes = new HashMap<Node, Boolean>();
        Node[] nodes = container instanceof CompositeNode ? ((CompositeNode)container).internalGetNodes() : container.getNodes();
        ArrayList<Node> eventNodes = new ArrayList<Node>();
        ArrayList<CompositeNode> compositeNodes = new ArrayList<CompositeNode>();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
            if (node instanceof EventNode) {
                eventNodes.add(node);
            }
            if (!(node instanceof CompositeNode)) continue;
            compositeNodes.add((CompositeNode)node);
        }
        if (isDynamic) {
            for (Node node2 : nodes) {
                if (!node2.getIncomingConnections("DROOLS_DEFAULT").isEmpty()) continue;
                this.processNode(node2, processNodes);
            }
        } else {
            List<Node> start = RuleFlowProcess.getStartNodes(nodes);
            if (start != null) {
                Iterator<Node> iterator = start.iterator();
                while (iterator.hasNext()) {
                    Node s = iterator.next();
                    this.processNode(s, processNodes);
                }
            }
            if (container instanceof CompositeNode) {
                for (CompositeNode.NodeAndType nodeAndTypes : ((CompositeNode)container).getLinkedIncomingNodes().values()) {
                    this.processNode(nodeAndTypes.getNode(), processNodes);
                }
            }
        }
        for (Node node : eventNodes) {
            this.processNode(node, processNodes);
        }
        for (CompositeNode compositeNode : compositeNodes) {
            this.checkAllNodesConnectedToStart(compositeNode, compositeNode instanceof DynamicNode, errors, process);
        }
        for (Node node : processNodes.keySet()) {
            if (!Boolean.FALSE.equals(processNodes.get(node)) || node instanceof StartNode || node instanceof EventSubProcessNode) continue;
            this.addErrorMessage(process, node, errors, "Has no connection to the start node.");
        }
    }

    private void processNode(Node node, Map<Node, Boolean> nodes) {
        if (!(nodes.containsKey(node) || node instanceof CompositeNode.CompositeNodeEnd || node instanceof ForEachNode.ForEachSplitNode || node instanceof ForEachNode.ForEachJoinNode)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process: " + node.getName());
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE || prevValue == null) {
            for (List list : node.getOutgoingConnections().values()) {
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    this.processNode(((Connection)it2.next()).getTo(), nodes);
                }
            }
        }
    }

    private boolean acceptsNoIncomingConnections(Node node) {
        NodeContainer nodeContainer = node.getNodeContainer();
        return nodeContainer instanceof DynamicNode || nodeContainer instanceof WorkflowProcess && ((WorkflowProcess)nodeContainer).isDynamic();
    }

    private boolean acceptsNoOutgoingConnections(Node node) {
        NodeContainer nodeContainer = node.getNodeContainer();
        return nodeContainer instanceof DynamicNode || nodeContainer instanceof WorkflowProcess && ((WorkflowProcess)nodeContainer).isDynamic();
    }

    private void validateTimer(Timer timer, Node node, RuleFlowProcess process, List<ProcessValidationError> errors) {
        if (timer.getDelay() == null && timer.getDate() == null) {
            this.addErrorMessage(process, node, errors, "Has timer with no delay or date specified.");
        } else if (timer.getDelay() != null && !timer.getDelay().contains("#{")) {
            try {
                switch (timer.getTimeType()) {
                    case 2: {
                        if (CronExpression.isValidExpression((String)timer.getDelay())) break;
                        DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                        break;
                    }
                    case 1: {
                        DateTimeUtils.parseDuration(timer.getDelay());
                        break;
                    }
                    case 3: {
                        DateTimeUtils.parseDateAsDuration(timer.getDate());
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                this.addErrorMessage(process, node, errors, "Could not parse delay '" + timer.getDelay() + "': " + e.getMessage());
            }
        }
        if (timer.getPeriod() != null && !timer.getPeriod().contains("#{")) {
            try {
                if (!CronExpression.isValidExpression((String)timer.getPeriod())) {
                    DateTimeUtils.parseRepeatableDateTime(timer.getPeriod());
                }
            }
            catch (RuntimeException e) {
                this.addErrorMessage(process, node, errors, "Could not parse period '" + timer.getPeriod() + "': " + e.getMessage());
            }
        }
        if (timer.getDate() != null && !timer.getDate().contains("#{")) {
            try {
                DateTimeUtils.parseDateAsDuration(timer.getDate());
            }
            catch (RuntimeException e) {
                this.addErrorMessage(process, node, errors, "Could not parse date '" + timer.getDate() + "': " + e.getMessage());
            }
        }
    }

    @Override
    public ProcessValidationError[] validateProcess(Process process) {
        if (!(process instanceof RuleFlowProcess)) {
            throw new IllegalArgumentException("This validator can only validate ruleflow processes!");
        }
        return this.validateProcess((RuleFlowProcess)process);
    }

    private void validateVariables(List<ProcessValidationError> errors, RuleFlowProcess process) {
        List<Variable> variables = process.getVariableScope().getVariables();
        if (variables != null) {
            for (Variable var : variables) {
                DataType varDataType = var.getType();
                if (varDataType != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Variable '" + var.getName() + "' has no type."));
            }
        }
    }

    @Override
    public boolean accept(Process process, Resource resource) {
        return "RuleFlow".equals(process.getType());
    }

    protected void validateCompensationIntermediateOrEndEvent(Node node, RuleFlowProcess process, List<ProcessValidationError> errors) {
        if (node.getMetaData().containsKey("Compensation")) {
            CompensationScope compensationScope;
            String activityRef = (String)node.getMetaData().get("Compensation");
            Node refNode = null;
            if (activityRef != null) {
                LinkedList<Node> nodeQueue = new LinkedList<Node>();
                nodeQueue.addAll(Arrays.asList(process.getNodes()));
                while (!nodeQueue.isEmpty()) {
                    Node polledNode = (Node)nodeQueue.poll();
                    if (activityRef.equals(polledNode.getMetaData().get("UniqueId"))) {
                        refNode = polledNode;
                        break;
                    }
                    if (!(node instanceof NodeContainer)) continue;
                    nodeQueue.addAll(Arrays.asList(((NodeContainer)node).getNodes()));
                }
            }
            if (refNode == null) {
                this.addErrorMessage(process, node, errors, "Does not reference an activity that exists (" + activityRef + ") in its compensation event definition.");
            }
            if ((compensationScope = (CompensationScope)((NodeImpl)node).resolveContext("CompensationScope", activityRef)) == null) {
                this.addErrorMessage(process, node, errors, "References an activity (" + activityRef + ") in its compensation event definition that is not visible to it.");
            }
        }
    }

    @Override
    public boolean compilationSupported() {
        return true;
    }

    protected void addErrorMessage(RuleFlowProcess process, Node node, List<ProcessValidationError> errors, String message) {
        String error = String.format("Node '%s' [%d] " + message, node.getName(), node.getId());
        errors.add(new ProcessValidationErrorImpl(process, error));
    }

    static {
        logger = LoggerFactory.getLogger(RuleFlowProcessValidator.class);
    }
}

