/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.util.Date;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProtobufProcessMarshaller;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.timer.TimerManagerRuntimeAdaptor;
import org.kie.services.time.JobContext;
import org.kie.services.time.JobHandle;
import org.kie.services.time.TimerService;
import org.kie.services.time.Trigger;
import org.kie.services.time.manager.TimerInstance;
import org.kie.services.time.manager.TimerManager;
import org.kie.services.time.manager.TimerManagerRuntime;

public class TimerManagerMarshallers {

    public static class ProcessTimerInputMarshaller
    implements TimersInputMarshaller {
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer timer) throws ClassNotFoundException {
            JBPMMessages.ProcessTimer ptimer = (JBPMMessages.ProcessTimer)timer.getExtension(JBPMMessages.procTimer);
            TimerService ts = inCtx.wm.getTimerService();
            String processInstanceId = ptimer.getTimer().getProcessInstanceId();
            Trigger trigger = ProtobufInputMarshaller.readTrigger((MarshallerReaderContext)inCtx, (ProtobufMessages.Trigger)ptimer.getTrigger());
            TimerInstance timerInstance = ProtobufProcessMarshaller.readTimer(inCtx, ptimer.getTimer());
            TimerManager tm = ((InternalProcessRuntime)inCtx.wm.getProcessRuntime()).getTimerManager();
            if (!tm.getTimerMap().containsKey(timerInstance.getId())) {
                long now;
                long then;
                TimerManagerRuntimeAdaptor rt = new TimerManagerRuntimeAdaptor(inCtx.wm.getKnowledgeRuntime());
                TimerManager.ProcessJobContext pctx = new TimerManager.ProcessJobContext(timerInstance, trigger, processInstanceId, (TimerManagerRuntime)rt, false);
                Date date = trigger.hasNextFireTime();
                if (date != null && (then = date.getTime()) < (now = pctx.getKnowledgeRuntime().getSessionClock().getCurrentTime())) {
                    trigger = new TimerManager.OverdueTrigger(trigger, pctx.getKnowledgeRuntime());
                }
                JobHandle jobHandle = ts.scheduleJob(TimerManager.processJob, (JobContext)pctx, trigger);
                timerInstance.setJobHandle(jobHandle);
                pctx.setJobHandle(jobHandle);
                tm.getTimerMap().put(timerInstance.getId(), timerInstance);
            }
        }
    }

    public static class ProcessTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            if (jobCtx instanceof TimerManager.StartProcessJobContext) {
                return null;
            }
            TimerManager.ProcessJobContext pctx = (TimerManager.ProcessJobContext)jobCtx;
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.PROCESS).setExtension(JBPMMessages.procTimer, (Object)JBPMMessages.ProcessTimer.newBuilder().setTimer(ProtobufProcessMarshaller.writeTimer(outputCtx, pctx.getTimer())).setTrigger(ProtobufOutputMarshaller.writeTrigger((Trigger)pctx.getTrigger(), (MarshallerWriteContext)outputCtx)).build()).build();
        }
    }
}

