/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.util.StringUtils;
import org.jbpm.marshalling.impl.ProcessInstanceMarshaller;
import org.jbpm.process.core.Context;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Process;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;

public abstract class AbstractProcessInstanceMarshaller
implements ProcessInstanceMarshaller {
    @Override
    public Object writeProcessInstance(MarshallerWriteContext context, ProcessInstance processInstance) throws IOException {
        WorkflowProcessInstanceImpl workFlow = (WorkflowProcessInstanceImpl)processInstance;
        MarshallerWriteContext stream = context.stream;
        stream.writeUTF(workFlow.getId());
        stream.writeUTF(workFlow.getProcessId());
        stream.writeInt(workFlow.getState());
        SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope");
        if (swimlaneContextInstance != null) {
            Map<String, String> swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
            stream.writeInt(swimlaneActors.size());
            for (Map.Entry<String, String> entry : swimlaneActors.entrySet()) {
                stream.writeUTF(entry.getKey());
                stream.writeUTF(entry.getValue());
            }
        } else {
            stream.writeInt(0);
        }
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(workFlow.getNodeInstances());
        Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

            @Override
            public int compare(NodeInstance o1, NodeInstance o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        for (NodeInstance nodeInstance : nodeInstances) {
            stream.writeShort(18);
            this.writeNodeInstance(context, nodeInstance);
        }
        stream.writeShort(1);
        List<ContextInstance> exclusiveGroupInstances = workFlow.getContextInstances("ExclusiveGroup");
        if (exclusiveGroupInstances == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(exclusiveGroupInstances.size());
            for (ContextInstance contextInstance : exclusiveGroupInstances) {
                ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                stream.writeInt(groupNodeInstances.size());
                for (NodeInstance nodeInstance : groupNodeInstances) {
                    stream.writeUTF(nodeInstance.getId());
                }
            }
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)workFlow.getContextInstance("VariableScope");
        Map<String, Object> variables = variableScopeInstance.getVariables();
        ArrayList<String> keys = new ArrayList<String>(variables.keySet());
        Collection<Object> values = variables.values();
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        ArrayList<Object> notNullValues = new ArrayList<Object>();
        for (Object value : values) {
            if (value == null) continue;
            notNullValues.add(value);
        }
        stream.writeInt(notNullValues.size());
        for (String key : keys) {
            Object object = variables.get(key);
            if (object == null) continue;
            stream.writeUTF(key);
            int useNewMarshallingStrategyAlgorithm = -2;
            stream.writeInt(useNewMarshallingStrategyAlgorithm);
            ObjectMarshallingStrategy strategy = context.objectMarshallingStrategyStore.getStrategyObject(object);
            stream.writeUTF(strategy.getClass().getName());
            strategy.write((ObjectOutputStream)stream, object);
        }
        return null;
    }

    @Override
    public Object writeNodeInstance(MarshallerWriteContext context, NodeInstance nodeInstance) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeUTF(nodeInstance.getId());
        stream.writeLong(nodeInstance.getNodeId());
        this.writeNodeInstanceContent((ObjectOutputStream)stream, nodeInstance, context);
        return null;
    }

    protected void writeNodeInstanceContent(ObjectOutputStream stream, NodeInstance nodeInstance, MarshallerWriteContext context) throws IOException {
        if (nodeInstance instanceof RuleSetNodeInstance) {
            stream.writeShort(20);
            List<String> timerInstances = ((RuleSetNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof HumanTaskNodeInstance) {
            stream.writeShort(27);
            stream.writeUTF(((HumanTaskNodeInstance)nodeInstance).getWorkItemId());
            List<String> timerInstances = ((HumanTaskNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof WorkItemNodeInstance) {
            stream.writeShort(21);
            stream.writeUTF(((WorkItemNodeInstance)nodeInstance).getWorkItemId());
            List<String> timerInstances = ((WorkItemNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof SubProcessNodeInstance) {
            stream.writeShort(22);
            stream.writeUTF(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId());
            List<String> timerInstances = ((SubProcessNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof MilestoneNodeInstance) {
            stream.writeShort(23);
            List<String> timerInstances = ((MilestoneNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof EventNodeInstance) {
            stream.writeShort(32);
        } else if (nodeInstance instanceof TimerNodeInstance) {
            stream.writeShort(24);
            stream.writeUTF(((TimerNodeInstance)nodeInstance).getTimerId());
        } else if (nodeInstance instanceof JoinInstance) {
            stream.writeShort(25);
            Map<Long, Integer> triggers = ((JoinInstance)nodeInstance).getTriggers();
            stream.writeInt(triggers.size());
            ArrayList<Long> keys = new ArrayList<Long>(triggers.keySet());
            Collections.sort(keys, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Long key : keys) {
                stream.writeLong(key);
                stream.writeInt(triggers.get(key));
            }
        } else if (nodeInstance instanceof StateNodeInstance) {
            stream.writeShort(30);
            List<String> timerInstances = ((StateNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof CompositeContextNodeInstance) {
            if (nodeInstance instanceof DynamicNodeInstance) {
                stream.writeShort(31);
            } else {
                stream.writeShort(26);
            }
            CompositeContextNodeInstance compositeNodeInstance = (CompositeContextNodeInstance)nodeInstance;
            List<String> timerInstances = ((CompositeContextNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)compositeNodeInstance.getContextInstance("VariableScope");
            if (variableScopeInstance == null) {
                stream.writeInt(0);
            } else {
                Map<String, Object> variables = variableScopeInstance.getVariables();
                ArrayList<String> keys = new ArrayList<String>(variables.keySet());
                Collections.sort(keys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                stream.writeInt(keys.size());
                Iterator<Object> iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    stream.writeUTF(key);
                    stream.writeObject(variables.get(key));
                }
            }
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(compositeNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
            List<ContextInstance> exclusiveGroupInstances = compositeNodeInstance.getContextInstances("ExclusiveGroup");
            if (exclusiveGroupInstances == null) {
                stream.writeInt(0);
            } else {
                stream.writeInt(exclusiveGroupInstances.size());
                for (ContextInstance contextInstance : exclusiveGroupInstances) {
                    ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                    Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                    stream.writeInt(groupNodeInstances.size());
                    for (NodeInstance groupNodeInstance : groupNodeInstances) {
                        stream.writeUTF(groupNodeInstance.getId());
                    }
                }
            }
        } else if (nodeInstance instanceof ForEachNodeInstance) {
            stream.writeShort(28);
            ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)nodeInstance;
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(forEachNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                if (!(subNodeInstance instanceof CompositeContextNodeInstance)) continue;
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
        } else {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
    }

    @Override
    public ProcessInstance readProcessInstance(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        InternalKnowledgeBase kBase = context.kBase;
        InternalWorkingMemory wm = context.wm;
        WorkflowProcessInstanceImpl processInstance = this.createProcessInstance();
        processInstance.setId(stream.readUTF());
        String processId = stream.readUTF();
        processInstance.setProcessId(processId);
        Process process = kBase.getProcess(processId);
        if (kBase != null) {
            processInstance.setProcess(process);
        }
        processInstance.setState(stream.readInt());
        long nodeInstanceCounter = stream.readLong();
        processInstance.setKnowledgeRuntime(wm.getKnowledgeRuntime());
        int nbSwimlanes = stream.readInt();
        if (nbSwimlanes > 0) {
            Context swimlaneContext = ((org.jbpm.process.core.Process)process).getDefaultContext("SwimlaneScope");
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance(swimlaneContext);
            for (int i = 0; i < nbSwimlanes; ++i) {
                String name = stream.readUTF();
                String value = stream.readUTF();
                swimlaneContextInstance.setActorId(name, value);
            }
        }
        while (stream.readShort() == 18) {
            this.readNodeInstance(context, processInstance, processInstance);
        }
        int exclusiveGroupInstances = stream.readInt();
        for (int i = 0; i < exclusiveGroupInstances; ++i) {
            ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
            processInstance.addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
            int nodeInstances = stream.readInt();
            for (int j = 0; j < nodeInstances; ++j) {
                String nodeInstanceId = stream.readUTF();
                org.jbpm.workflow.instance.NodeInstance nodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                if (nodeInstance == null) {
                    throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                }
                exclusiveGroupInstance.addNodeInstance(nodeInstance);
            }
        }
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            Context variableScope = ((org.jbpm.process.core.Process)process).getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance(variableScope);
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    String strategyClassName;
                    ObjectMarshallingStrategy strategy = null;
                    int index = stream.readInt();
                    if (index >= 0) {
                        strategy = context.resolverStrategyFactory.getStrategy(index);
                    } else if (index == -2 && !StringUtils.isEmpty((CharSequence)(strategyClassName = context.stream.readUTF())) && (strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName)) == null) {
                        throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                    }
                    Object value = null;
                    if (strategy != null) {
                        value = strategy.read((ObjectInputStream)stream);
                    }
                    variableScopeInstance.internalSetVariable(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        if (wm != null) {
            processInstance.reconnect();
        }
        return processInstance;
    }

    protected abstract WorkflowProcessInstanceImpl createProcessInstance();

    @Override
    public NodeInstance readNodeInstance(MarshallerReaderContext context, NodeInstanceContainer nodeInstanceContainer, org.kie.api.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        MarshallerReaderContext stream = context.stream;
        String id = stream.readUTF();
        long nodeId = stream.readLong();
        short nodeType = stream.readShort();
        NodeInstanceImpl nodeInstance = this.readNodeInstanceContent(nodeType, (ObjectInputStream)stream, context, processInstance);
        nodeInstance.setNodeId(nodeId);
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        nodeInstance.setId(id);
        switch (nodeType) {
            case 26: 
            case 31: {
                int nbVariables = stream.readInt();
                if (nbVariables > 0) {
                    Context variableScope = ((org.jbpm.process.core.Process)((org.jbpm.process.instance.ProcessInstance)processInstance).getProcess()).getDefaultContext("VariableScope");
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((CompositeContextNodeInstance)nodeInstance).getContextInstance(variableScope);
                    for (int i = 0; i < nbVariables; ++i) {
                        String name = stream.readUTF();
                        try {
                            Object value = stream.readObject();
                            variableScopeInstance.internalSetVariable(name, value);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not reload variable " + name);
                        }
                    }
                }
                while (stream.readShort() == 18) {
                    this.readNodeInstance(context, (CompositeContextNodeInstance)nodeInstance, processInstance);
                }
                int exclusiveGroupInstances = stream.readInt();
                for (int i = 0; i < exclusiveGroupInstances; ++i) {
                    ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
                    ((org.jbpm.process.instance.ProcessInstance)processInstance).addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
                    int nodeInstances = stream.readInt();
                    for (int j = 0; j < nodeInstances; ++j) {
                        String nodeInstanceId = stream.readUTF();
                        NodeInstance groupNodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                        if (groupNodeInstance == null) {
                            throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                        }
                        exclusiveGroupInstance.addNodeInstance(groupNodeInstance);
                    }
                }
                break;
            }
            case 28: {
                while (stream.readShort() == 18) {
                    this.readNodeInstance(context, (ForEachNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
        }
        return nodeInstance;
    }

    protected NodeInstanceImpl readNodeInstanceContent(int nodeType, ObjectInputStream stream, MarshallerReaderContext context, org.kie.api.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        NodeInstanceImpl nodeInstance = null;
        switch (nodeType) {
            case 20: {
                nodeInstance = new RuleSetNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((StateBasedNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 27: {
                nodeInstance = new HumanTaskNodeInstance();
                ((HumanTaskNodeInstance)nodeInstance).internalSetWorkItemId(stream.readUTF());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((HumanTaskNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 21: {
                nodeInstance = new WorkItemNodeInstance();
                ((WorkItemNodeInstance)nodeInstance).internalSetWorkItemId(stream.readUTF());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((WorkItemNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 22: {
                nodeInstance = new SubProcessNodeInstance();
                ((SubProcessNodeInstance)nodeInstance).internalSetProcessInstanceId(stream.readUTF());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((SubProcessNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 23: {
                nodeInstance = new MilestoneNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((MilestoneNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 24: {
                nodeInstance = new TimerNodeInstance();
                ((TimerNodeInstance)nodeInstance).internalSetTimerId(stream.readUTF());
                break;
            }
            case 32: {
                nodeInstance = new EventNodeInstance();
                break;
            }
            case 25: {
                nodeInstance = new JoinInstance();
                int number = stream.readInt();
                if (number <= 0) break;
                HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
                for (int i = 0; i < number; ++i) {
                    long l = stream.readLong();
                    int count = stream.readInt();
                    triggers.put(l, count);
                }
                ((JoinInstance)nodeInstance).internalSetTriggers(triggers);
                break;
            }
            case 26: {
                nodeInstance = new CompositeContextNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 28: {
                nodeInstance = new ForEachNodeInstance();
                break;
            }
            case 31: {
                nodeInstance = new DynamicNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 30: {
                nodeInstance = new StateNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + nodeType);
            }
        }
        return nodeInstance;
    }
}

