/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeImpl;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.kie.api.definition.process.Process;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessInstanceResolverStrategy
implements ObjectMarshallingStrategy {
    public boolean accept(Object object) {
        return object instanceof ProcessInstance;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        ProcessInstance processInstance = (ProcessInstance)object;
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, os);
        os.writeUTF(processInstance.getId());
    }

    public Object read(ObjectInputStream is) throws IOException, ClassNotFoundException {
        String processInstanceId = is.readUTF();
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager(is);
        ProcessInstance processInstance = pim.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            RuleFlowProcessInstance result = new RuleFlowProcessInstance();
            result.setId(processInstanceId);
            result.internalSetState(2);
            return result;
        }
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, is);
        return processInstance;
    }

    public static ProcessInstanceManager retrieveProcessInstanceManager(Object streamContext) {
        ProcessInstanceManager pim = null;
        if (streamContext instanceof MarshallerWriteContext) {
            MarshallerWriteContext context = (MarshallerWriteContext)streamContext;
            pim = ((ProcessRuntimeImpl)context.wm.getProcessRuntime()).getProcessInstanceManager();
        } else if (streamContext instanceof MarshallerReaderContext) {
            MarshallerReaderContext context = (MarshallerReaderContext)streamContext;
            pim = ((ProcessRuntimeImpl)context.wm.getProcessRuntime()).getProcessInstanceManager();
        } else {
            throw new UnsupportedOperationException("Unable to retrieve " + ProcessInstanceManager.class.getSimpleName() + " from " + streamContext.getClass().getName());
        }
        return pim;
    }

    private void connectProcessInstanceToRuntimeAndProcess(ProcessInstance processInstance, Object streamContext) {
        Process process;
        String processId;
        ProcessInstanceImpl processInstanceImpl = (ProcessInstanceImpl)processInstance;
        InternalKnowledgeRuntime kruntime = processInstanceImpl.getKnowledgeRuntime();
        if (kruntime == null) {
            kruntime = ProcessInstanceResolverStrategy.retrieveKnowledgeRuntime(streamContext);
            processInstanceImpl.setKnowledgeRuntime(kruntime);
        }
        if (processInstance.getProcess() == null && (processId = processInstance.getProcessId()) != null && (process = kruntime.getKieBase().getProcess(processId)) != null) {
            processInstanceImpl.setProcess(process);
        }
    }

    public static InternalKnowledgeRuntime retrieveKnowledgeRuntime(Object streamContext) {
        InternalKnowledgeRuntime kruntime = null;
        if (streamContext instanceof MarshallerWriteContext) {
            MarshallerWriteContext context = (MarshallerWriteContext)streamContext;
            kruntime = context.wm.getKnowledgeRuntime();
        } else if (streamContext instanceof MarshallerReaderContext) {
            MarshallerReaderContext context = (MarshallerReaderContext)streamContext;
            kruntime = context.wm.getKnowledgeRuntime();
        } else {
            throw new UnsupportedOperationException("Unable to retrieve " + ProcessInstanceManager.class.getSimpleName() + " from " + streamContext.getClass().getName());
        }
        return kruntime;
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        ProcessInstance processInstance = (ProcessInstance)object;
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, os);
        return processInstance.getId().getBytes();
    }

    public Object unmarshal(String dataType, ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        String processInstanceId = new String(object);
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager(is);
        ProcessInstance processInstance = pim.getProcessInstance(processInstanceId, true);
        if (processInstance == null) {
            RuleFlowProcessInstance result = new RuleFlowProcessInstance();
            result.setId(processInstanceId);
            result.internalSetState(2);
            return result;
        }
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, is);
        return processInstance;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

