/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.LightProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeContext;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.Model;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.impl.ConfiguredProcessServices;
import org.kie.kogito.process.impl.MapProcessInstances;
import org.kie.kogito.process.impl.Sig;

public abstract class AbstractProcess<T extends Model>
implements Process<T> {
    protected ProcessInstancesFactory processInstancesFactory;
    protected MutableProcessInstances<T> instances;
    protected final ProcessRuntimeServiceProvider services;
    protected CompletionEventListener completionEventListener = new CompletionEventListener();
    protected boolean activated;
    protected List<String> startTimerInstances = new ArrayList<String>();
    protected ProcessRuntime processRuntime;

    protected AbstractProcess() {
        this(new LightProcessRuntimeServiceProvider());
    }

    protected AbstractProcess(ProcessConfig config) {
        this(new ConfiguredProcessServices(config));
    }

    protected AbstractProcess(ProcessRuntimeServiceProvider services) {
        this.services = services;
        this.instances = new MapProcessInstances();
    }

    public String id() {
        return this.legacyProcess().getId();
    }

    public T createModel() {
        return null;
    }

    public ProcessInstance<T> createInstance(Model m) {
        return this.createInstance(m);
    }

    public ProcessInstance<T> createInstance(String businessKey, Model m) {
        return this.createInstance(businessKey, m);
    }

    public ProcessInstances<T> instances() {
        return this.instances;
    }

    public <S> void send(Signal<S> signal) {
        this.instances().values().forEach(pi -> pi.send(signal));
    }

    public Process<T> configure() {
        this.registerListeners();
        if (this.isProcessFactorySet()) {
            this.instances = this.processInstancesFactory.createProcessInstances((Process)this);
        }
        return this;
    }

    protected void registerListeners() {
    }

    public void activate() {
        this.configure();
        WorkflowProcessImpl p = (WorkflowProcessImpl)this.legacyProcess();
        List<StartNode> startNodes = p.getTimerStart();
        if (startNodes != null && !startNodes.isEmpty()) {
            this.processRuntime = this.createLegacyProcessRuntime();
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                String timerId = this.processRuntime.getJobsService().scheduleProcessJob(ProcessJobDescription.of((ExpirationTime)this.configureTimerInstance(startNode.getTimer()), (Process)this));
                this.startTimerInstances.add(timerId);
            }
        }
        this.activated = true;
    }

    public void deactivate() {
        for (String startTimerId : this.startTimerInstances) {
            this.processRuntime.getJobsService().cancelJob(startTimerId);
        }
        this.activated = false;
    }

    protected ExpirationTime configureTimerInstance(Timer timer) {
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount > -1) {
                        parsedReapedCount = Integer.MAX_VALUE;
                    }
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2]);
                }
                long delay = repeatValues[0];
                long period = -1L;
                try {
                    period = TimeUtils.parseTimeString((String)timer.getPeriod());
                }
                catch (RuntimeException e) {
                    period = repeatValues[0];
                }
                return DurationExpirationTime.repeat((long)delay, (Long)period);
            }
            case 1: {
                duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.repeat((long)duration);
            }
            case 3: {
                return ExactExpirationTime.of((String)timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    public abstract org.kie.api.definition.process.Process legacyProcess();

    protected ProcessRuntime createLegacyProcessRuntime() {
        return new LightProcessRuntime(new LightProcessRuntimeContext(Collections.singletonList(this.legacyProcess())), this.services);
    }

    protected boolean isProcessFactorySet() {
        return this.processInstancesFactory != null;
    }

    public void setProcessInstancesFactory(ProcessInstancesFactory processInstancesFactory) {
        this.processInstancesFactory = processInstancesFactory;
    }

    private class CompletionEventListener
    implements EventListener {
        private CompletionEventListener() {
        }

        public void signalEvent(String type, Object event) {
            if (type.startsWith("processInstanceCompleted:")) {
                org.kie.api.runtime.process.ProcessInstance pi = (org.kie.api.runtime.process.ProcessInstance)event;
                if (!AbstractProcess.this.id().equals(pi.getProcessId()) && pi.getParentProcessInstanceId() != null) {
                    AbstractProcess.this.instances().findById(pi.getParentProcessInstanceId()).ifPresent(p -> p.send(Sig.of(type, event)));
                }
            }
        }

        public String[] getEventTypes() {
            return new String[0];
        }
    }
}

