/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.KieSessionInitializer;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.drools.serialization.protobuf.ProtobufInputMarshaller;
import org.drools.serialization.protobuf.ProtobufMarshaller;
import org.drools.serialization.protobuf.ProtobufMarshallerReaderContext;
import org.drools.serialization.protobuf.ProtobufMarshallerWriteContext;
import org.drools.serialization.protobuf.ProtobufOutputMarshaller;
import org.drools.serialization.protobuf.ReadSessionResult;
import org.jbpm.marshalling.impl.KogitoMarshallerReaderContext;
import org.jbpm.marshalling.impl.KogitoMarshallerWriteContext;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.marshalling.MarshallingConfiguration;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class KogitoProtobufMarshaller
extends ProtobufMarshaller {
    public KogitoProtobufMarshaller(KieBase kbase, MarshallingConfiguration marshallingConfig) {
        super(kbase, marshallingConfig);
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream) throws IOException, ClassNotFoundException {
        return this.unmarshall(stream, null, null);
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        return this.unmarshallWithMessage(stream, config, environment).getSession();
    }

    public void unmarshall(InputStream stream, KieSession ksession) throws IOException, ClassNotFoundException {
        KogitoMarshallerReaderContext context = this.getMarshallerReaderContext(stream, ksession.getEnvironment());
        ProtobufInputMarshaller.readSession((StatefulKnowledgeSessionImpl)((StatefulKnowledgeSessionImpl)ksession), (ProtobufMarshallerReaderContext)context);
        context.close();
    }

    public void marshall(OutputStream stream, KieSession ksession) throws IOException {
        this.marshall(stream, ksession, ksession.getSessionClock().getCurrentTime());
    }

    public void marshall(OutputStream stream, KieSession ksession, long clockTime) throws IOException {
        ((InternalWorkingMemory)ksession).flushPropagations();
        KogitoMarshallerWriteContext context = new KogitoMarshallerWriteContext(stream, (InternalKnowledgeBase)this.kbase, (InternalWorkingMemory)ksession, RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((InternalKnowledgeBase)this.kbase)), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        context.setClockTime(clockTime);
        ProtobufOutputMarshaller.writeSession((ProtobufMarshallerWriteContext)context);
        context.close();
    }

    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfig;
    }

    public ReadSessionResult unmarshallWithMessage(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        if (config == null) {
            config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = KieServices.get().newEnvironment();
        }
        KogitoMarshallerReaderContext context = this.getMarshallerReaderContext(stream, environment);
        int id = ((KnowledgeBaseImpl)this.kbase).nextWorkingMemoryCounter();
        ReadSessionResult readSessionResult = ProtobufInputMarshaller.readSession((ProtobufMarshallerReaderContext)context, (int)id, (Environment)environment, (SessionConfiguration)((SessionConfiguration)config), (KieSessionInitializer)this.initializer);
        context.close();
        if (((SessionConfiguration)config).isKeepReference()) {
            ((KnowledgeBaseImpl)this.kbase).addStatefulSession(readSessionResult.getSession());
        }
        return readSessionResult;
    }

    private KogitoMarshallerReaderContext getMarshallerReaderContext(InputStream inputStream, Environment environment) throws IOException {
        return new KogitoMarshallerReaderContext(inputStream, (InternalKnowledgeBase)((KnowledgeBaseImpl)this.kbase), RuleBaseNodes.getNodeMap((InternalKnowledgeBase)((KnowledgeBaseImpl)this.kbase)), this.strategyStore, TIMER_READERS, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), environment);
    }
}

