/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.actions;

import java.io.Serializable;
import java.util.function.Function;
import org.jbpm.process.core.event.EventTransformerImpl;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class SignalProcessInstanceAction
implements Action,
Serializable {
    public static final String DEFAULT_SCOPE = "default";
    public static final String PROCESS_INSTANCE_SCOPE = "processInstance";
    public static final String EXTERNAL_SCOPE = "external";
    public static final String UNSET_SCOPE = System.getProperty("org.jbpm.signals.defaultscope", "processInstance");
    private static final long serialVersionUID = 1L;
    private final String signalNameTemplate;
    private String variableName;
    private Function<KogitoProcessContext, Object> eventDataSupplier = kcontext -> null;
    private String scope = UNSET_SCOPE;
    private Transformation transformation;

    public SignalProcessInstanceAction(String signalName, String variableName) {
        this.signalNameTemplate = signalName;
        this.variableName = variableName;
    }

    public SignalProcessInstanceAction(String signalName, String variableName, Transformation transformation) {
        this.signalNameTemplate = signalName;
        this.variableName = variableName;
        this.transformation = transformation;
    }

    public SignalProcessInstanceAction(String signalName, String variableName, String scope) {
        this.signalNameTemplate = signalName;
        this.variableName = variableName;
        if (scope != null) {
            this.scope = scope;
        }
    }

    public SignalProcessInstanceAction(String signalName, String variableName, String scope, Transformation transformation) {
        this.signalNameTemplate = signalName;
        this.variableName = variableName;
        if (scope != null) {
            this.scope = scope;
        }
        this.transformation = transformation;
    }

    public SignalProcessInstanceAction(String signalName, Function<KogitoProcessContext, Object> eventDataSupplier, String scope) {
        this.signalNameTemplate = signalName;
        this.eventDataSupplier = eventDataSupplier;
        if (scope != null) {
            this.scope = scope;
        }
    }

    @Override
    public void execute(KogitoProcessContext context) throws Exception {
        String variableName = VariableUtil.resolveVariable(this.variableName, (NodeInstance)context.getNodeInstance());
        Object signal = variableName == null ? this.eventDataSupplier.apply(context) : context.getVariable(variableName);
        KogitoProcessInstance processInstance = context.getProcessInstance();
        KogitoNodeInstance nodeInstance = context.getNodeInstance();
        if (this.transformation != null) {
            signal = new EventTransformerImpl(this.transformation).transformEvent(processInstance.getVariables());
        }
        if (signal == null) {
            signal = variableName;
        }
        String signalName = VariableUtil.resolveVariable(this.signalNameTemplate, (NodeInstance)context.getNodeInstance());
        context.getKogitoProcessRuntime().getProcessEventSupport().fireOnSignal(processInstance, nodeInstance, context.getKieRuntime(), signalName, signal);
        if (DEFAULT_SCOPE.equals(this.scope)) {
            context.getKogitoProcessRuntime().signalEvent(signalName, signal);
        } else if (PROCESS_INSTANCE_SCOPE.equals(this.scope)) {
            context.getProcessInstance().signalEvent(signalName, signal);
        } else if (EXTERNAL_SCOPE.equals(this.scope)) {
            KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
            workItem.setName("External Send Task");
            workItem.setNodeInstanceId(context.getNodeInstance().getStringId());
            workItem.setProcessInstanceId(context.getProcessInstance().getStringId());
            workItem.setNodeId(context.getNodeInstance().getNodeId());
            workItem.setParameter("Signal", (Object)signalName);
            workItem.setParameter("SignalProcessInstanceId", context.getVariable("SignalProcessInstanceId"));
            workItem.setParameter("SignalWorkItemId", context.getVariable("SignalWorkItemId"));
            workItem.setParameter("SignalDeploymentId", context.getVariable("SignalDeploymentId"));
            if (signal == null) {
                workItem.setParameter("Data", signal);
            }
            ((InternalKogitoWorkItemManager)context.getKogitoProcessRuntime().getKogitoWorkItemManager()).internalExecuteWorkItem((InternalKogitoWorkItem)workItem);
        }
    }

    public String getSignalName() {
        return this.signalNameTemplate;
    }
}

