/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.services.event.EventConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEventConsumer<D, M extends Model>
implements EventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(DataEventConsumer.class);
    private Function<D, M> function;
    private ProcessService processService;
    private ExecutorService executorService;

    public DataEventConsumer(ProcessService processService, ExecutorService executorService, Function<D, M> function) {
        this.processService = processService;
        this.executorService = executorService;
        this.function = function;
    }

    public CompletionStage<Void> consume(Application application, Process<M> process, Object eventData, String trigger) {
        return CompletableFuture.runAsync(() -> this.processService.createProcessInstance(process, (Model)this.function.apply(eventData), null, trigger, null), this.executorService);
    }
}

