/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import org.drools.core.spi.KogitoProcessContextImpl;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.kogito.event.process.ContextAwareEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;

public class MilestoneNodeInstance
extends StateBasedNodeInstance {
    private static final long serialVersionUID = 510L;

    protected MilestoneNode getMilestoneNode() {
        return (MilestoneNode)this.getNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A MilestoneNode only accepts default incoming connections!");
        }
        if (this.isCompleted()) {
            this.triggerCompleted();
        } else {
            this.addCompletionEventListener();
        }
    }

    private boolean isCompleted() {
        KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        context.setNodeInstance((NodeInstance)this);
        return this.getMilestoneNode().canComplete((ProcessContext)context);
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addCompletionEventListener();
    }

    private void addCompletionEventListener() {
        this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().addEventListener(ContextAwareEventListener.using(listener -> {
            if (this.isCompleted()) {
                this.triggerCompleted();
                this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime().removeEventListener((ProcessEventListener)listener);
            }
        }));
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(this.getActivationEventType(), this, true);
    }

    private String getActivationEventType() {
        return "RuleFlow-Milestone-" + this.getProcessInstance().getProcessId() + "-" + this.getMilestoneNode().getUniqueId();
    }
}

