/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.kie.kogito.services.event.AbstractProcessDataEvent;
import org.kie.kogito.services.event.EventConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventConsumer<D, M extends Model, T extends AbstractProcessDataEvent<D>>
implements EventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(CloudEventConsumer.class);
    private Function<D, M> function;
    private ProcessService processService;
    private ExecutorService executor;

    public CloudEventConsumer(ProcessService processService, ExecutorService executor, Function<D, M> function) {
        this.processService = processService;
        this.executor = executor;
        this.function = function;
    }

    public CompletionStage<?> consume(Application application, Process<M> process, Object object, String trigger) {
        AbstractProcessDataEvent cloudEvent = (AbstractProcessDataEvent)object;
        Model model = (Model)this.function.apply(cloudEvent.getData());
        String simpleName = cloudEvent.getClass().getSimpleName();
        if (this.ignoredMessageType(cloudEvent, simpleName) && this.ignoredMessageType(cloudEvent, trigger)) {
            logger.warn("Consumer for CloudEvent type '{}', trigger '{}': ignoring message with type '{}',  source '{}'", new Object[]{simpleName, trigger, cloudEvent.getType(), cloudEvent.getSource()});
            return CompletableFuture.completedFuture(null);
        }
        if (cloudEvent.getKogitoReferenceId() != null && !cloudEvent.getKogitoReferenceId().isEmpty()) {
            logger.debug("Received message with reference id '{}' going to use it to send signal '{}'", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
            Optional instance = process.instances().findById(cloudEvent.getKogitoReferenceId());
            if (instance.isPresent()) {
                return CompletableFuture.completedFuture(this.processService.signalProcessInstance(process, cloudEvent.getKogitoReferenceId(), cloudEvent.getData(), "Message-" + trigger));
            }
            logger.warn("Process instance with id '{}' not found for triggering signal '{}', starting a new one", (Object)cloudEvent.getKogitoReferenceId(), (Object)trigger);
            return this.startNewInstance(process, model, cloudEvent, trigger);
        }
        logger.debug("Received message without reference id, starting new process instance with trigger '{}'", (Object)trigger);
        return this.startNewInstance(process, model, cloudEvent, trigger);
    }

    private CompletionStage<Void> startNewInstance(Process<M> process, M model, T cloudEvent, String trigger) {
        return CompletableFuture.runAsync(() -> this.processService.createProcessInstance(process, model, cloudEvent.getKogitoStartFromNode(), trigger, cloudEvent.getKogitoProcessinstanceId()), this.executor);
    }

    private boolean ignoredMessageType(T cloudEvent, String type) {
        return !type.equals(cloudEvent.getType()) && !type.equals(cloudEvent.getSource());
    }
}

