/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.EnumDataType;
import org.jbpm.process.core.datatype.impl.type.FloatDataType;
import org.jbpm.process.core.datatype.impl.type.IntegerDataType;
import org.jbpm.process.core.datatype.impl.type.ListDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;

public class DataTypeResolver {
    public static final DataType defaultDataType = new ObjectDataType("java.lang.Object");
    private static final Map<Class<?>, DataType> dataTypes = new HashMap();

    private DataTypeResolver() {
    }

    public static DataType fromType(String type, ClassLoader cl) {
        return type == null ? defaultDataType : DataTypeResolver.from(type, cl);
    }

    public static DataType fromObject(Object value) {
        return value == null ? defaultDataType : DataTypeResolver.from(value.getClass()).orElse(DataTypeResolver.buildObjectDataType(value.getClass().getCanonicalName()));
    }

    private static DataType from(String type, ClassLoader cl) {
        if (!((String)type).contains(".")) {
            type = "java.lang." + (String)type;
        }
        try {
            return DataTypeResolver.from(cl.loadClass((String)type)).orElse(new ObjectDataType((String)type, cl));
        }
        catch (ClassNotFoundException ex) {
            return new ObjectDataType((String)type);
        }
    }

    private static Optional<DataType> from(Class<?> type) {
        for (Map.Entry<Class<?>, DataType> entry : dataTypes.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private static DataType buildObjectDataType(String type) {
        try {
            Class.forName(type);
            return new ObjectDataType(type);
        }
        catch (ClassNotFoundException ex) {
            return defaultDataType;
        }
    }

    static {
        dataTypes.put(Boolean.class, new BooleanDataType());
        dataTypes.put(String.class, new StringDataType());
        dataTypes.put(Integer.class, new IntegerDataType());
        dataTypes.put(Float.class, new FloatDataType());
        dataTypes.put(Collection.class, new ListDataType());
        dataTypes.put(Enum.class, new EnumDataType());
    }
}

