/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.type;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.coverter.TypeConverterRegistry;

public class ObjectDataType
implements DataType {
    private static final long serialVersionUID = 510L;
    private String className;
    private ClassLoader classLoader;

    public ObjectDataType() {
    }

    public ObjectDataType(String className) {
        this.setClassName(className);
    }

    public ObjectDataType(String className, ClassLoader classLoader) {
        this.setClassName(className);
        this.setClassLoader(classLoader);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value == null) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(this.className, true, value.getClass().getClassLoader());
            if (clazz.isInstance(value)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find data type " + this.className);
        }
        return false;
    }

    @Override
    public Object readValue(String value) {
        return TypeConverterRegistry.get().forType(this.getStringType()).apply(value);
    }

    @Override
    public String writeValue(Object value) {
        return value.toString();
    }

    @Override
    public String getStringType() {
        return this.className == null ? "java.lang.Object" : this.className;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectDataType that = (ObjectDataType)o;
        return Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }
}

