/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.transformation;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonResolver {
    private final ObjectMapper objectMapper;

    public JsonResolver(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JsonResolver() {
        this(new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE));
    }

    public Map<String, Object> resolveOnlyAnnotatedItems(Map<String, Object> items) {
        if (Objects.isNull(items)) {
            return null;
        }
        Map<String, Map> resolved = items.entrySet().stream().filter(v -> Objects.nonNull(v.getValue())).filter(v -> this.hasJacksonAnnotations(v.getValue().getClass())).collect(Collectors.toMap(Map.Entry::getKey, v -> (Map)this.objectMapper.convertValue(v.getValue(), Map.class)));
        HashMap<String, Object> result = new HashMap<String, Object>(items);
        result.putAll(resolved);
        return result;
    }

    public Map<String, Object> resolveAll(Map<String, Object> items) {
        return Optional.ofNullable(items).map(input -> (Map)this.objectMapper.convertValue((Object)items, Map.class)).orElse(null);
    }

    private boolean hasJacksonAnnotations(AnnotatedElement element) {
        Annotation[] declaredAnnotations = element.getDeclaredAnnotations();
        Annotation[] declaringClassAnnotations = Optional.of(element).filter(Field.class::isInstance).map(Field.class::cast).map(Field::getType).map(Class::getDeclaredAnnotations).orElse(new Annotation[0]);
        if (Stream.of(declaredAnnotations, declaringClassAnnotations).flatMap(Stream::of).anyMatch(a -> ((JacksonAnnotation[])a.annotationType().getAnnotationsByType(JacksonAnnotation.class)).length > 0)) {
            return true;
        }
        if (!(element instanceof Class) || ((Class)element).isPrimitive()) {
            return false;
        }
        Class clazz = (Class)element;
        return Arrays.stream(clazz.getDeclaredFields()).anyMatch(f -> this.hasJacksonAnnotations((AnnotatedElement)f));
    }
}

