/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.drools.core.process.instance.WorkItem;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemHandler;
import org.jbpm.process.instance.impl.workitem.Abort;
import org.jbpm.process.instance.impl.workitem.Complete;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.internal.process.runtime.WorkItemNotFoundException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.KogitoWorkItemHandlerNotFoundException;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.kie.kogito.signal.SignalManager;

public class LightWorkItemManager
implements InternalKogitoWorkItemManager {
    private Map<String, InternalKogitoWorkItem> workItems = new ConcurrentHashMap<String, InternalKogitoWorkItem>();
    private Map<String, KogitoWorkItemHandler> workItemHandlers = new HashMap<String, KogitoWorkItemHandler>();
    private final ProcessInstanceManager processInstanceManager;
    private final SignalManager signalManager;
    private final KogitoProcessEventSupport eventSupport;
    private Complete completePhase = new Complete();
    private Abort abortPhase = new Abort();

    public LightWorkItemManager(ProcessInstanceManager processInstanceManager, SignalManager signalManager, KogitoProcessEventSupport eventSupport) {
        this.processInstanceManager = processInstanceManager;
        this.signalManager = signalManager;
        this.eventSupport = eventSupport;
    }

    public void internalExecuteWorkItem(InternalKogitoWorkItem workItem) {
        ((KogitoWorkItemImpl)workItem).setId(UUID.randomUUID().toString());
        this.internalAddWorkItem(workItem);
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler == null) {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
        TransitionToActive transition = new TransitionToActive();
        this.eventSupport.fireBeforeWorkItemTransition(processInstance, (KogitoWorkItem)workItem, (Transition)transition, null);
        handler.executeWorkItem((KogitoWorkItem)workItem, (KogitoWorkItemManager)this);
        this.eventSupport.fireAfterWorkItemTransition(processInstance, (KogitoWorkItem)workItem, (Transition)transition, null);
    }

    public void internalAddWorkItem(InternalKogitoWorkItem workItem) {
        this.workItems.put(workItem.getStringId(), workItem);
    }

    public void internalAbortWorkItem(String id) {
        KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            workItem.setCompleteDate(new Date());
            KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler == null) {
                this.workItems.remove(workItem.getStringId());
                throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
            }
            KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
            TransitionToAbort transition = new TransitionToAbort(Collections.emptyList());
            this.eventSupport.fireBeforeWorkItemTransition(processInstance, (KogitoWorkItem)workItem, (Transition)transition, null);
            handler.abortWorkItem((KogitoWorkItem)workItem, (KogitoWorkItemManager)this);
            workItem.setPhaseId("abort");
            workItem.setPhaseStatus("Aborted");
            this.eventSupport.fireAfterWorkItemTransition(processInstance, (KogitoWorkItem)workItem, (Transition)transition, null);
            this.workItems.remove(workItem.getStringId());
        }
    }

    public void retryWorkItem(String workItemId) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        this.retryWorkItem(workItem);
    }

    public void retryWorkItemWithParams(String workItemId, Map<String, Object> map) {
        InternalKogitoWorkItem workItem = this.workItems.get(workItemId);
        if (workItem != null) {
            workItem.setParameters(map);
            this.retryWorkItem(workItem);
        }
    }

    private void retryWorkItem(InternalKogitoWorkItem workItem) {
        if (workItem != null) {
            KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.executeWorkItem((KogitoWorkItem)workItem, (KogitoWorkItemManager)this);
            } else {
                throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
            }
        }
    }

    public InternalKogitoWorkItem getWorkItem(String id) {
        return this.workItems.get(id);
    }

    public void internalRemoveWorkItem(String id) {
        this.workItems.remove(id);
    }

    public void completeWorkItem(String id, Map<String, Object> results, Policy<?> ... policies) {
        this.transitionWorkItem(id, new TransitionToComplete(results, Arrays.asList(policies)));
    }

    public <T> T updateWorkItem(String id, Function<KogitoWorkItem, T> updater, Policy<?> ... policies) {
        InternalKogitoWorkItem workItem = this.workItems.get(id);
        if (workItem != null) {
            if (!workItem.enforce(policies)) {
                throw new NotAuthorizedException("User is not authorized to access task instance with id " + id);
            }
            T results = updater.apply((KogitoWorkItem)workItem);
            this.eventSupport.fireAfterWorkItemTransition(this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId()), (KogitoWorkItem)workItem, null, null);
            return results;
        }
        throw new WorkItemNotFoundException(id);
    }

    public void internalCompleteWorkItem(InternalKogitoWorkItem workItem) {
        KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
        workItem.setState(2);
        workItem.setCompleteDate(new Date());
        if (processInstance != null) {
            processInstance.signalEvent("workItemCompleted", (Object)workItem);
        }
        this.workItems.remove(workItem.getStringId());
    }

    public void transitionWorkItem(String id, Transition<?> transition) {
        InternalKogitoWorkItem workItem = this.workItems.get(id);
        if (workItem == null) {
            throw new WorkItemNotFoundException("Work Item (" + id + ") does not exist", id);
        }
        this.transitionWorkItem(workItem, transition);
    }

    private void transitionWorkItem(InternalKogitoWorkItem workItem, Transition<?> transition) {
        KogitoProcessInstance processInstance;
        KogitoWorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
            this.eventSupport.fireBeforeWorkItemTransition(processInstance, (KogitoWorkItem)workItem, transition, null);
            if (!HumanTaskWorkItemHandler.transitionToPhase(handler, (KogitoWorkItem)workItem, (KogitoWorkItemManager)this, transition)) {
                workItem.setResults((Map)transition.data());
                workItem.setPhaseId("complete");
                workItem.setPhaseStatus("Completed");
                this.completePhase.apply((KogitoWorkItem)workItem, transition);
                this.internalCompleteWorkItem(workItem);
            }
        } else {
            throw new KogitoWorkItemHandlerNotFoundException(workItem.getName());
        }
        processInstance.signalEvent("workItemTransition", transition);
        this.eventSupport.fireAfterWorkItemTransition(processInstance, (KogitoWorkItem)workItem, transition, null);
    }

    public void abortWorkItem(String id, Policy<?> ... policies) {
        KogitoWorkItemImpl workItem = (KogitoWorkItemImpl)this.workItems.get(id);
        if (workItem != null) {
            if (!workItem.enforce(policies)) {
                throw new NotAuthorizedException("Work item can be aborted as it does not fulfil policies (e.g. security)");
            }
            KogitoProcessInstance processInstance = this.processInstanceManager.getProcessInstance(workItem.getProcessInstanceStringId());
            TransitionToAbort transition = new TransitionToAbort(Arrays.asList(policies));
            this.eventSupport.fireBeforeWorkItemTransition(processInstance, (KogitoWorkItem)workItem, (Transition)transition, null);
            workItem.setState(3);
            this.abortPhase.apply((KogitoWorkItem)workItem, transition);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            workItem.setPhaseId("abort");
            workItem.setPhaseStatus("Aborted");
            this.eventSupport.fireAfterWorkItemTransition(processInstance, (KogitoWorkItem)workItem, (Transition)transition, null);
            this.workItems.remove(id);
        }
    }

    public void completeWorkItem(long l, Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public void abortWorkItem(long l) {
        throw new UnsupportedOperationException();
    }

    public void registerWorkItemHandler(String workItemName, KogitoWorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clear() {
        this.workItems.clear();
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public void signalEvent(String type, Object event, String processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    public void retryWorkItem(String workItemID, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            this.retryWorkItem(workItemID);
        } else {
            this.retryWorkItemWithParams(workItemID, params);
        }
    }

    public Set<WorkItem> getWorkItems() {
        throw new UnsupportedOperationException();
    }

    private static class TransitionToComplete
    implements Transition<Map<String, Object>> {
        private Map<String, Object> data;
        private List<Policy<?>> policies;

        TransitionToComplete(Map<String, Object> data, List<Policy<?>> policies) {
            this.data = data;
            this.policies = policies;
        }

        public String phase() {
            return "complete";
        }

        public Map<String, Object> data() {
            return this.data;
        }

        public List<Policy<?>> policies() {
            return this.policies;
        }
    }

    private static class TransitionToAbort
    implements Transition<Void> {
        private List<Policy<?>> policies;

        TransitionToAbort(List<Policy<?>> policies) {
            this.policies = policies;
        }

        public String phase() {
            return "abort";
        }

        public Void data() {
            return null;
        }

        public List<Policy<?>> policies() {
            return this.policies;
        }
    }

    private static class TransitionToActive
    implements Transition<Void> {
        private TransitionToActive() {
        }

        public String phase() {
            return "active";
        }

        public Void data() {
            return null;
        }

        public List<Policy<?>> policies() {
            return Collections.emptyList();
        }
    }
}

