/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.context.variable.Mappable;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.DataAssociation;
import org.kie.api.definition.process.Connection;

public class EndNode
extends ExtendedNodeImpl
implements Mappable {
    public static final int CONTAINER_SCOPE = 0;
    public static final int PROCESS_SCOPE = 1;
    private static final String[] EVENT_TYPES = new String[]{"onEntry"};
    private static final long serialVersionUID = 510L;
    private boolean terminate = true;
    private int scope = 0;
    private List<DataAssociation> inMapping = new LinkedList<DataAssociation>();

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    @Override
    public String[] getActionTypes() {
        return EVENT_TYPES;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && !"true".equals(System.getProperty("jbpm.enable.multi.con"))) {
            throw new IllegalArgumentException("This type of node [" + connection.getTo().getMetaData().get("UniqueId") + ", " + connection.getTo().getName() + "] cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        throw new UnsupportedOperationException("An end node does not have an outgoing connection!");
    }

    @Override
    public void validateRemoveOutgoingConnection(String type, Connection connection) {
        throw new UnsupportedOperationException("An end node does not have an outgoing connection!");
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getScope() {
        return this.scope;
    }

    @Override
    public void addInAssociation(DataAssociation dataAssociation) {
        this.inMapping.add(dataAssociation);
    }

    @Override
    public List<DataAssociation> getInAssociations() {
        return Collections.unmodifiableList(this.inMapping);
    }

    @Override
    public void addOutAssociation(DataAssociation dataAssociation) {
        this.throwUnsupported();
    }

    @Override
    public List<DataAssociation> getOutAssociations() {
        return Collections.emptyList();
    }

    @Override
    public void addOutMapping(String parameterName, String variableName) {
        this.throwUnsupported();
    }

    private void throwUnsupported() {
        throw new IllegalArgumentException("An end event [" + this.getMetaData("UniqueId") + ", " + this.getName() + "] does not support output mappings");
    }

    @Override
    public String getOutMapping(String parameterName) {
        return null;
    }

    @Override
    public Map<String, String> getOutMappings() {
        return Collections.emptyMap();
    }

    @Override
    public void setOutMappings(Map<String, String> outMapping) {
        this.throwUnsupported();
    }

    @Override
    public void addInMapping(String parameterName, String variableName) {
        this.inMapping.add(new DataAssociation(variableName, parameterName, null, null));
    }

    @Override
    public String getInMapping(String parameterName) {
        return this.getInMappings().get(parameterName);
    }

    @Override
    public Map<String, String> getInMappings() {
        HashMap<String, String> in = new HashMap<String, String>();
        for (DataAssociation a : this.inMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && !a.getAssignments().isEmpty() || a.getTransformation() != null) continue;
            in.put(a.getTarget(), a.getSources().get(0));
        }
        return in;
    }

    @Override
    public void setInMappings(Map<String, String> inMapping) {
        this.inMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : inMapping.entrySet()) {
            this.addInMapping(entry.getKey(), entry.getValue());
        }
    }
}

