/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.process.BaseEventDescription;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.timer.TimerInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(TimerNodeInstance.class);
    private static final String TIMER_TRIGGERED_EVENT = "timerTriggered";
    private String timerId;

    public TimerNode getTimerNode() {
        return (TimerNode)this.getNode();
    }

    public String getTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(String timerId) {
        this.timerId = timerId;
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A TimerNode only accepts default incoming connections!");
        }
        this.triggerTime = new Date();
        ExpirationTime expirationTime = this.createTimerInstance(this.getTimerNode().getTimer());
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
        ProcessInstanceJobDescription jobDescription = ProcessInstanceJobDescription.of((long)this.getTimerNode().getTimer().getId(), (ExpirationTime)expirationTime, (String)this.getProcessInstance().getStringId(), (String)this.getProcessInstance().getRootProcessInstanceId(), (String)this.getProcessInstance().getProcessId(), (String)this.getProcessInstance().getRootProcessId(), (String)Optional.ofNullable(from).map(KogitoNodeInstance::getStringId).orElse(null));
        JobsService jobService = KogitoProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService();
        this.timerId = jobService.scheduleProcessInstanceJob(jobDescription);
    }

    @Override
    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        if (TIMER_TRIGGERED_EVENT.equals(type) && (timer = (TimerInstance)event).getId().equals(this.timerId)) {
            this.triggerCompleted(timer.getRepeatLimit() <= 0);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{TIMER_TRIGGERED_EVENT};
    }

    @Override
    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    @Override
    public void cancel() {
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getJobsService().cancelJob(this.timerId);
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(TIMER_TRIGGERED_EVENT, this, false);
    }

    public Set<EventDescription<?>> getEventDescriptions() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("TimerID", this.timerId);
        properties.put("Delay", this.getTimerNode().getTimer().getDelay());
        properties.put("Period", this.getTimerNode().getTimer().getPeriod());
        properties.put("Date", this.getTimerNode().getTimer().getDate());
        return Collections.singleton(new BaseEventDescription(TIMER_TRIGGERED_EVENT, this.getNodeDefinitionId(), this.getNodeName(), "timer", this.getStringId(), this.getProcessInstance().getStringId(), null, properties));
    }
}

