/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jbpm.process.core.context.variable.Mappable;
import org.jbpm.workflow.core.node.DataAssociation;

public class Trigger
implements Mappable,
Serializable {
    private static final long serialVersionUID = 510L;
    private List<DataAssociation> inMapping = new LinkedList<DataAssociation>();

    @Override
    public void addInMapping(String subVariableName, String variableName) {
        this.inMapping.add(new DataAssociation(subVariableName, variableName, null, null));
    }

    @Override
    public void setInMappings(Map<String, String> inMapping) {
        this.inMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : inMapping.entrySet()) {
            this.addInMapping(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getInMapping(String parameterName) {
        return this.getInMappings().get(parameterName);
    }

    @Override
    public Map<String, String> getInMappings() {
        HashMap<String, String> in = new HashMap<String, String>();
        for (DataAssociation a : this.inMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && !a.getAssignments().isEmpty() || a.getTransformation() != null) continue;
            in.put(a.getSources().get(0), a.getTarget());
        }
        return in;
    }

    @Override
    public void addInAssociation(DataAssociation dataAssociation) {
        this.inMapping.add(dataAssociation);
    }

    @Override
    public List<DataAssociation> getInAssociations() {
        return Collections.unmodifiableList(this.inMapping);
    }

    @Override
    public void addOutMapping(String subVariableName, String variableName) {
        throw new IllegalArgumentException("A trigger does not support out mappings");
    }

    @Override
    public void setOutMappings(Map<String, String> outMapping) {
        throw new IllegalArgumentException("A trigger does not support out mappings");
    }

    @Override
    public String getOutMapping(String parameterName) {
        throw new IllegalArgumentException("A trigger does not support out mappings");
    }

    @Override
    public Map<String, String> getOutMappings() {
        throw new IllegalArgumentException("A trigger does not support out mappings");
    }

    @Override
    public void addOutAssociation(DataAssociation dataAssociation) {
        throw new IllegalArgumentException("A trigger does not support out mappings");
    }

    @Override
    public List<DataAssociation> getOutAssociations() {
        throw new IllegalArgumentException("A trigger does not support out mappings");
    }
}

