/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventNodeInterface;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.DummyEventListener;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.FaultNodeInstance;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;

public class CompositeNodeInstance
extends StateBasedNodeInstance
implements NodeInstanceContainer,
EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    private static final long serialVersionUID = 510L;
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private int state = 1;
    private Map<String, Integer> iterationLevels = new HashMap<String, Integer>();
    private int currentLevel;

    @Override
    public int getLevelForNode(String uniqueID) {
        if (Boolean.parseBoolean(System.getProperty("jbpm.loop.level.disabled"))) {
            return 1;
        }
        Integer value = this.iterationLevels.get(uniqueID);
        if (value == null && this.currentLevel == 0) {
            value = 1;
        } else if (value == null && this.currentLevel > 0 || value != null && this.currentLevel > 0 && value > this.currentLevel) {
            value = this.currentLevel;
        } else {
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
        }
        this.iterationLevels.put(uniqueID, value);
        return value;
    }

    @Override
    public void setProcessInstance(WorkflowProcessInstance processInstance) {
        super.setProcessInstance(processInstance);
        this.registerExternalEventNodeListeners();
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getCompositeNode().getNodes()) {
            if (node instanceof EventNode) {
                if (!"external".equals(((EventNode)node).getScope())) continue;
                this.getProcessInstance().addEventListener(((EventNode)node).getType(), DummyEventListener.EMPTY_EVENT_LISTENER, true);
                continue;
            }
            if (!(node instanceof EventSubProcessNode)) continue;
            List<String> events = ((EventSubProcessNode)node).getEvents();
            for (String type : events) {
                this.getProcessInstance().addEventListener(type, DummyEventListener.EMPTY_EVENT_LISTENER, true);
            }
        }
    }

    protected CompositeNode getCompositeNode() {
        return (CompositeNode)this.getNode();
    }

    @Override
    public NodeContainer getNodeContainer() {
        return this.getCompositeNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        CompositeNode.NodeAndType nodeAndType = this.getCompositeNode().internalGetLinkedIncomingNode(type);
        if (nodeAndType != null) {
            List connections = nodeAndType.getNode().getIncomingConnections(nodeAndType.getType());
            for (Connection connection : connections) {
                if (!(connection.getFrom() instanceof CompositeNode.CompositeNodeStart) || from != null && ((CompositeNode.CompositeNodeStart)connection.getFrom()).getInNode().getId() != from.getNodeId()) continue;
                NodeInstance nodeInstance = this.getNodeInstance(connection.getFrom());
                nodeInstance.trigger(null, nodeAndType.getType());
                return;
            }
        } else {
            boolean found = false;
            for (Node node : this.getCompositeNode().getNodes()) {
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node).getTriggers() != null && !startNode.getTriggers().isEmpty()) continue;
                NodeInstance nodeInstance = this.getNodeInstance((Node)startNode);
                nodeInstance.trigger(null, null);
                found = true;
            }
            if (found) {
                return;
            }
        }
        if (this.isLinkedIncomingNodeRequired()) {
            throw new IllegalArgumentException("Could not find start for composite node: " + type);
        }
    }

    protected void internalTriggerOnlyParent(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
    }

    protected boolean isLinkedIncomingNodeRequired() {
        return true;
    }

    public void triggerCompleted(String outType) {
        boolean cancelRemainingInstances = this.getCompositeNode().isCancelRemainingInstances();
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.triggerCompleted(outType, cancelRemainingInstances);
        if (cancelRemainingInstances) {
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
        }
    }

    @Override
    public void cancel() {
        while (!this.nodeInstances.isEmpty()) {
            NodeInstance nodeInstance = this.nodeInstances.get(0);
            nodeInstance.cancel();
        }
        super.cancel();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        if (nodeInstance.getStringId() == null) {
            ((NodeInstanceImpl)nodeInstance).setId(UUID.randomUUID().toString());
        }
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        this.nodeInstances.remove(nodeInstance);
    }

    public Collection<org.kie.api.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<NodeInstance>(this.getNodeInstances(false));
    }

    public org.kie.api.runtime.process.NodeInstance getNodeInstance(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<KogitoNodeInstance> getKogitoNodeInstances(Predicate<KogitoNodeInstance> filter, boolean recursive) {
        ArrayList<KogitoNodeInstance> result = new ArrayList<KogitoNodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance instanceof KogitoNodeInstance && filter.test(nodeInstance)) {
                result.add(nodeInstance);
            }
            if (!(nodeInstance instanceof KogitoNodeInstanceContainer) || !recursive) continue;
            result.addAll(((KogitoNodeInstanceContainer)nodeInstance).getKogitoNodeInstances(filter, true));
        }
        return result;
    }

    public NodeInstance getNodeInstance(String nodeInstanceId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!nodeInstance.getStringId().equals(nodeInstanceId)) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getNodeInstance(String nodeInstanceId, boolean recursive) {
        for (NodeInstance nodeInstance : this.getNodeInstances(recursive)) {
            if (!nodeInstance.getStringId().equals(nodeInstanceId)) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId || nodeInstance.getLevel() != this.getCurrentLevel()) continue;
            return nodeInstance;
        }
        return null;
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        if (node instanceof CompositeNode.CompositeNodeStart) {
            return this.buildCompositeNodeInstance(new CompositeNodeStartInstance(), node);
        }
        if (node instanceof CompositeNode.CompositeNodeEnd) {
            return this.buildCompositeNodeInstance(new CompositeNodeEndInstance(), node);
        }
        Node actualNode = this.resolveAsync(node);
        NodeInstanceFactory conf = NodeInstanceFactoryRegistry.getInstance(this.getProcessInstance().getKnowledgeRuntime().getEnvironment()).getProcessNodeInstanceFactory(actualNode);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(actualNode, this.getProcessInstance(), (org.kie.api.runtime.process.NodeInstanceContainer)this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        return nodeInstance;
    }

    private NodeInstance buildCompositeNodeInstance(NodeInstanceImpl nodeInstance, Node node) {
        nodeInstance.setNodeId(node.getId());
        nodeInstance.setNodeInstanceContainer(this);
        nodeInstance.setProcessInstance(this.getProcessInstance());
        return nodeInstance;
    }

    @Override
    public void signalEvent(String type, Object event) {
        ArrayList<NodeInstance> currentView = new ArrayList<NodeInstance>(this.nodeInstances);
        super.signalEvent(type, event);
        for (Node node : this.getCompositeNode().internalGetNodes()) {
            if (node instanceof EventNodeInterface && ((EventNodeInterface)node).acceptsEvent(type, event)) {
                if (node instanceof EventNode && ((EventNode)node).getFrom() == null || node instanceof EventSubProcessNode) {
                    EventNodeInstanceInterface eventNodeInstance = (EventNodeInstanceInterface)((Object)this.getNodeInstance(node));
                    eventNodeInstance.signalEvent(type, event);
                } else {
                    List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId(), currentView);
                    if (nodeInstances != null && !nodeInstances.isEmpty()) {
                        for (NodeInstance nodeInstance : nodeInstances) {
                            ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
                        }
                    }
                }
            }
            if (!type.equals(node.getName()) || !node.getIncomingConnections().isEmpty()) continue;
            NodeInstance nodeInstance = this.getNodeInstance(node);
            if (event != null) {
                HashMap<String, Object> dynamicParams = new HashMap<String, Object>(this.getProcessInstance().getVariables());
                if (event instanceof Map) {
                    dynamicParams.putAll((Map)event);
                } else {
                    dynamicParams.put("Data", event);
                }
                nodeInstance.setDynamicParameters(dynamicParams);
            }
            nodeInstance.trigger(null, "DROOLS_DEFAULT");
        }
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    public List<NodeInstance> getNodeInstances(long nodeId, List<NodeInstance> currentView) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : currentView) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).removeEventListeners();
        }
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Object compensationBoolObj;
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null && (compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation")) != null && ((Boolean)compensationBoolObj).booleanValue()) {
            return;
        }
        if (nodeInstance instanceof FaultNodeInstance || nodeInstance instanceof EndNodeInstance || nodeInstance instanceof EventSubProcessNodeInstance) {
            if (this.getCompositeNode().isAutoComplete() && this.nodeInstances.isEmpty()) {
                this.triggerCompleted("DROOLS_DEFAULT");
            }
        } else {
            throw new IllegalArgumentException("Completing a node instance that has no outgoing connection not supported.");
        }
    }

    @Override
    public void setState(int state) {
        this.state = state;
        if (state == 3) {
            this.cancel();
        }
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public Map<String, Integer> getIterationLevels() {
        return this.iterationLevels;
    }

    public class CompositeNodeEndInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public CompositeNode.CompositeNodeEnd getCompositeNodeEnd() {
            return (CompositeNode.CompositeNodeEnd)this.getNode();
        }

        @Override
        public void internalTrigger(KogitoNodeInstance from, String type) {
            this.triggerTime = new Date();
            this.triggerCompleted();
        }

        public void triggerCompleted() {
            CompositeNodeInstance.this.triggerCompleted(this.getCompositeNodeEnd().getOutType());
        }
    }

    public static class CompositeNodeStartInstance
    extends NodeInstanceImpl {
        private static final long serialVersionUID = 510L;

        public CompositeNode.CompositeNodeStart getCompositeNodeStart() {
            return (CompositeNode.CompositeNodeStart)this.getNode();
        }

        @Override
        public void internalTrigger(KogitoNodeInstance from, String type) {
            this.triggerTime = new Date();
            this.triggerCompleted();
        }

        public void triggerCompleted() {
            super.triggerCompleted("DROOLS_DEFAULT", true);
        }
    }
}

