/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.core.spi.KogitoProcessContextImpl;
import org.drools.core.util.StringUtils;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.util.ContextFactory;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.SubProcessFactory;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaSubProcessNodeInstance
extends StateBasedNodeInstance
implements KogitoEventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(LambdaSubProcessNodeInstance.class);
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private String processInstanceId;
    private boolean asyncWaitingNodeInstance;

    protected SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A SubProcess node only accepts default incoming connections!");
        }
        KogitoProcessContextImpl context = ContextFactory.fromNode(this);
        SubProcessFactory subProcessFactory = this.getSubProcessNode().getSubProcessFactory();
        Object o = subProcessFactory.bind((ProcessContext)context);
        ProcessInstance processInstance = subProcessFactory.createInstance(o);
        WorkflowProcessInstance pi = ((AbstractProcessInstance)processInstance).internalGetProcessInstance();
        ((ProcessInstanceImpl)((Object)pi)).setMetaData("ParentProcessInstanceId", this.getProcessInstance().getStringId());
        ((ProcessInstanceImpl)((Object)pi)).setMetaData("ParentNodeInstanceId", this.getUniqueId());
        ((ProcessInstanceImpl)((Object)pi)).setMetaData("ParentNodeId", this.getSubProcessNode().getUniqueId());
        ((ProcessInstanceImpl)((Object)pi)).setParentProcessInstanceId(this.getProcessInstance().getStringId());
        ((ProcessInstanceImpl)((Object)pi)).setRootProcessInstanceId(StringUtils.isEmpty((CharSequence)this.getProcessInstance().getRootProcessInstanceId()) ? this.getProcessInstance().getStringId() : this.getProcessInstance().getRootProcessInstanceId());
        ((ProcessInstanceImpl)((Object)pi)).setRootProcessId(StringUtils.isEmpty((CharSequence)this.getProcessInstance().getRootProcessId()) ? this.getProcessInstance().getProcessId() : this.getProcessInstance().getRootProcessId());
        ((ProcessInstanceImpl)((Object)pi)).setSignalCompletion(this.getSubProcessNode().isWaitForCompletion());
        processInstance.start();
        this.processInstanceId = processInstance.id();
        this.asyncWaitingNodeInstance = this.hasAsyncNodeInstance((org.kie.api.runtime.process.ProcessInstance)pi);
        subProcessFactory.unbind((ProcessContext)context, processInstance.variables());
        if (!this.getSubProcessNode().isWaitForCompletion()) {
            this.triggerCompleted();
        } else if (processInstance.status() == 2 || processInstance.status() == 3) {
            this.triggerCompleted();
        } else {
            this.addProcessListener();
        }
    }

    private boolean hasAsyncNodeInstance(org.kie.api.runtime.process.ProcessInstance pi) {
        return Optional.ofNullable(pi).map(ProcessInstanceImpl.class::cast).map(instance -> instance.getMetaData().get("ASYNC_WAITING")).map(Boolean.class::cast).orElse(false);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.getSubProcessNode() == null || !this.getSubProcessNode().isIndependent()) {
            org.jbpm.process.instance.ProcessInstance processInstance = null;
            KogitoProcessRuntime kruntime = (KogitoProcessRuntime)this.getProcessInstance().getKnowledgeRuntime();
            processInstance = (org.jbpm.process.instance.ProcessInstance)kruntime.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.setState(3);
            }
        }
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public boolean isAsyncWaitingNodeInstance() {
        return this.asyncWaitingNodeInstance;
    }

    public void internalSetProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addProcessListener();
    }

    private void addProcessListener() {
        this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (("processInstanceCompleted:" + this.processInstanceId).equals(type)) {
            this.processInstanceCompleted((org.jbpm.process.instance.ProcessInstance)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"processInstanceCompleted:" + this.processInstanceId};
    }

    public void processInstanceCompleted(org.jbpm.process.instance.ProcessInstance processInstance) {
        this.removeEventListeners();
        this.handleOutMappings(processInstance);
        if (processInstance.getState() == 3) {
            String faultName = processInstance.getOutcome() == null ? "" : processInstance.getOutcome();
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", faultName);
            if (exceptionScopeInstance != null) {
                exceptionScopeInstance.handleException(faultName, processInstance.getFaultData());
                if (this.getSubProcessNode() != null && !this.getSubProcessNode().isIndependent() && this.getSubProcessNode().isAbortParent()) {
                    this.cancel();
                }
                return;
            }
            if (this.getSubProcessNode() != null && !this.getSubProcessNode().isIndependent() && this.getSubProcessNode().isAbortParent()) {
                this.getProcessInstance().setState(3, faultName);
                return;
            }
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", "SubProcessNode");
        }
        this.triggerCompleted();
    }

    private void handleOutMappings(org.jbpm.process.instance.ProcessInstance processInstance) {
        SubProcessFactory subProcessFactory = this.getSubProcessNode().getSubProcessFactory();
        ProcessInstance pi = (ProcessInstance)processInstance.getMetaData().get("KogitoProcessInstance");
        if (pi != null) {
            subProcessFactory.unbind((ProcessContext)ContextFactory.fromNode(this), pi.variables());
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            return "[Dynamic] Sub Process";
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getSubProcessNode();
    }

    protected Map<String, Object> getSourceParameters(DataAssociation association) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String sourceParam : association.getSources()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", sourceParam);
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(sourceParam);
            } else {
                try {
                    parameterValue = MVELProcessHelper.evaluator().eval(sourceParam, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    logger.warn("Could not find variable scope for variable {}", (Object)sourceParam);
                }
            }
            if (parameterValue == null) continue;
            parameters.put(association.getTarget(), parameterValue);
        }
        return parameters;
    }
}

