/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.CommandServiceTimerJobFactoryManager;
import org.drools.core.time.impl.ThreadSafeTrackableTimeJobFactoryManager;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.AbstractProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceFactory;
import org.jbpm.process.instance.ProcessInstanceFactoryRegistry;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.KieBase;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.utils.CompositeClassLoader;
import org.kie.kogito.Application;
import org.kie.kogito.drools.core.event.KogitoProcessEventSupportImpl;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.jobs.impl.LegacyInMemoryJobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRuntimeImpl
extends AbstractProcessRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessRuntimeImpl.class);
    private InternalKnowledgeRuntime kruntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private JobsService jobService;
    private UnitOfWorkManager unitOfWorkManager;

    public ProcessRuntimeImpl(Application application, InternalKnowledgeRuntime kruntime) {
        super(application);
        this.kruntime = kruntime;
        TimerService timerService = kruntime.getTimerService();
        if (!(timerService.getTimerJobFactoryManager() instanceof CommandServiceTimerJobFactoryManager)) {
            timerService.setTimerJobFactoryManager((TimerJobFactoryManager)new ThreadSafeTrackableTimeJobFactoryManager());
        }
        ((CompositeClassLoader)this.getRootClassLoader()).addClassLoader(this.getClass().getClassLoader());
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.unitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
        this.jobService = new LegacyInMemoryJobService((KogitoProcessRuntime)this.kogitoProcessRuntime, this.unitOfWorkManager);
        this.processEventSupport = new KogitoProcessEventSupportImpl(this.unitOfWorkManager);
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    public ProcessRuntimeImpl(Application application, InternalWorkingMemory workingMemory) {
        super(application);
        TimerService timerService = workingMemory.getTimerService();
        if (!(timerService.getTimerJobFactoryManager() instanceof CommandServiceTimerJobFactoryManager)) {
            timerService.setTimerJobFactoryManager((TimerJobFactoryManager)new ThreadSafeTrackableTimeJobFactoryManager());
        }
        this.kruntime = workingMemory.getKnowledgeRuntime();
        this.initProcessInstanceManager();
        this.initSignalManager();
        this.unitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
        this.jobService = new LegacyInMemoryJobService((KogitoProcessRuntime)this.kogitoProcessRuntime, this.unitOfWorkManager);
        this.processEventSupport = new KogitoProcessEventSupportImpl(this.unitOfWorkManager);
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    public void initStartTimers() {
        KieBase kbase = this.kruntime.getKieBase();
        Collection processes = kbase.getProcesses();
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                this.jobService.scheduleProcessJob(ProcessJobDescription.of((ExpirationTime)this.createTimerInstance(startNode.getTimer(), this.kruntime), (String)p.getId()));
            }
        }
    }

    private void initProcessInstanceManager() {
        this.processInstanceManager = new DefaultProcessInstanceManagerFactory().createProcessInstanceManager(this.kruntime);
    }

    private void initSignalManager() {
        this.signalManager = new DefaultSignalManagerFactory().createSignalManager(this.kruntime);
    }

    @Override
    public KogitoProcessRuntime getKogitoProcessRuntime() {
        return this.kogitoProcessRuntime;
    }

    private ClassLoader getRootClassLoader() {
        KieBase kbase = this.kruntime.getKieBase();
        if (kbase != null) {
            return ((InternalKnowledgeBase)kbase).getRootClassLoader();
        }
        CompositeClassLoader result = new CompositeClassLoader();
        result.addClassLoader(Thread.currentThread().getContextClassLoader());
        return result;
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId) {
        return this.kogitoProcessRuntime.startProcess(processId, null, null, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.kogitoProcessRuntime.startProcess(processId, parameters, null, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger) {
        return this.kogitoProcessRuntime.startProcess(processId, parameters, trigger, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, AgendaFilter agendaFilter) {
        return this.kogitoProcessRuntime.startProcess(processId, null, null, agendaFilter);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, AgendaFilter agendaFilter) {
        return this.kogitoProcessRuntime.startProcess(processId, parameters, null, agendaFilter);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessFromNodeIds(String s, Map<String, Object> map, String ... strings) {
        throw new UnsupportedOperationException("org.jbpm.process.instance.ProcessRuntimeImpl.startProcessFromNodeIds -> TODO");
    }

    public KogitoProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.createProcessInstance(processId, null, parameters);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(long l) {
        throw new UnsupportedOperationException();
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        KogitoProcessInstance processInstance = this.createProcessInstance(processId, correlationKey, parameters);
        if (processInstance != null) {
            return this.startProcessInstance(processInstance.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KogitoProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        try {
            this.kruntime.startOperation();
            Process process = this.kruntime.getKieBase().getProcess(processId);
            if (process == null) {
                throw new IllegalArgumentException("Unknown process ID: " + processId);
            }
            ProcessInstance processInstance = this.startProcess(process, correlationKey, parameters);
            return processInstance;
        }
        finally {
            this.kruntime.endOperation();
        }
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessFromNodeIds(String s, CorrelationKey correlationKey, Map<String, Object> map, String ... strings) {
        throw new UnsupportedOperationException("org.jbpm.process.instance.ProcessRuntimeImpl.startProcessFromNodeIds -> TODO");
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        throw new UnsupportedOperationException("org.jbpm.process.instance.ProcessRuntimeImpl.getProcessInstance -> TODO");
    }

    private ProcessInstance startProcess(Process process, CorrelationKey correlationKey, Map<String, Object> parameters) {
        ProcessInstanceFactory conf = ProcessInstanceFactoryRegistry.INSTANCE.getProcessInstanceFactory(process);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal process type: " + process.getClass());
        }
        return conf.createProcessInstance(process, correlationKey, this.kruntime, parameters);
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public JobsService getJobsService() {
        return this.jobService;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long l) {
        throw new UnsupportedOperationException();
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(long l, boolean b) {
        throw new UnsupportedOperationException();
    }

    public void abortProcessInstance(long l) {
        throw new UnsupportedOperationException();
    }

    public KogitoProcessInstance getProcessInstance(String id) {
        return this.getProcessInstance(id, false);
    }

    public KogitoProcessInstance getProcessInstance(String id, boolean readOnly) {
        return this.processInstanceManager.getProcessInstance(id, readOnly);
    }

    public void removeProcessInstance(KogitoProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    public void initProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.initProcessEventListener(process);
        }
    }

    public void removeProcessEventListeners() {
        for (Process process : this.kruntime.getKieBase().getProcesses()) {
            this.removeProcessEventListener(process);
        }
    }

    private void removeProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            String type = (String)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventType");
            StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventListener");
            if (type != null && listener != null) {
                this.signalManager.removeEventListener(type, (EventListener)listener);
            }
        }
    }

    private void initProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            for (Node node : ((RuleFlowProcess)process).getNodes()) {
                List<Trigger> triggers;
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node) == null || (triggers = startNode.getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                    String type = null;
                    for (EventFilter filter : filters) {
                        if (!(filter instanceof EventTypeFilter)) continue;
                        type = ((EventTypeFilter)filter).getType();
                    }
                    StartProcessEventListener listener = new StartProcessEventListener(startNode, trigger, process.getId(), filters);
                    this.signalManager.addEventListener(type, (EventListener)listener);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventType", type);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventListener", listener);
                }
            }
        }
    }

    private void initProcessActivationListener() {
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlowStateNode-")) {
                        int index = ruleName.indexOf(45, 18);
                        index = ruleName.indexOf(45, index + 1);
                        String eventType = ruleName.substring(0, index);
                        ((ReteEvaluator)ProcessRuntimeImpl.this.kruntime).addPropagation((PropagationEntry)new SignalManagerSignalAction(eventType, event), true);
                    } else if (ruleName.startsWith("RuleFlowStateEventSubProcess-") || ruleName.startsWith("RuleFlowStateEvent-") || ruleName.startsWith("RuleFlow-Milestone-") || ruleName.startsWith("RuleFlow-AdHocComplete-") || ruleName.startsWith("RuleFlow-AdHocActivate-")) {
                        ((ReteEvaluator)ProcessRuntimeImpl.this.kruntime).addPropagation((PropagationEntry)new SignalManagerSignalAction(ruleName, event), true);
                    }
                } else {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlow-Start-")) {
                        String processId = ruleName.replace("RuleFlow-Start-", "");
                        ProcessRuntimeImpl.this.startProcessWithParamsAndTrigger(processId, null, "conditional", true);
                    }
                }
            }
        });
        this.kruntime.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                if (ProcessRuntimeImpl.this.kruntime instanceof StatefulKnowledgeSession) {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)ProcessRuntimeImpl.this.kruntime).getIdentifier(), null);
                } else {
                    ProcessRuntimeImpl.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                }
            }
        });
    }

    private void startProcessWithParamsAndTrigger(String processId, Map<String, Object> params, String type, boolean dispose) {
        this.startProcess(processId, params, type);
    }

    public WorkItemManager getWorkItemManager() {
        return this.kruntime.getWorkItemManager();
    }

    @Override
    public UnitOfWorkManager getUnitOfWorkManager() {
        return this.unitOfWorkManager;
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String s, Object o, long l) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.processEventSupport.reset();
        this.kruntime = null;
    }

    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    public void clearProcessInstancesState() {
        this.processInstanceManager.clearProcessInstancesState();
    }

    public boolean isActive() {
        Boolean active = (Boolean)this.kruntime.getEnvironment().get("Active");
        if (active == null) {
            return true;
        }
        return active;
    }

    protected ExpirationTime createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            long delay = businessCalendar.calculateBusinessTimeAsDuration(timer.getDelay());
            if (timer.getPeriod() == null) {
                return DurationExpirationTime.repeat((long)delay);
            }
            long period = businessCalendar.calculateBusinessTimeAsDuration(timer.getPeriod());
            return DurationExpirationTime.repeat((long)delay, (Long)period);
        }
        return this.configureTimerInstance(timer);
    }

    private ExpirationTime configureTimerInstance(Timer timer) {
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2], (Integer)parsedReapedCount);
                }
                long delay = repeatValues[0];
                long period = -1L;
                try {
                    period = TimeUtils.parseTimeString((String)timer.getPeriod());
                }
                catch (RuntimeException e) {
                    period = repeatValues[0];
                }
                return DurationExpirationTime.repeat((long)delay, (Long)period);
            }
            case 1: {
                duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.after((long)duration);
            }
            case 3: {
                return ExactExpirationTime.of((String)timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    @Override
    public InternalKnowledgeRuntime getInternalKieRuntime() {
        return this.kruntime;
    }

    public class SignalManagerSignalAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalManagerSignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public void execute(ReteEvaluator reteEvaluator) {
            ProcessRuntimeImpl.this.signalEvent(this.type, this.event);
        }
    }

    private class StartProcessWithTypeCommand
    implements ExecutableCommand<Void> {
        private static final long serialVersionUID = -8890906804846111698L;
        private String processId;
        private Map<String, Object> params;
        private String type;

        private StartProcessWithTypeCommand(String processId, Map<String, Object> params, String type) {
            this.processId = processId;
            this.params = params;
            this.type = type;
        }

        public Void execute(Context context) {
            KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
            ((ProcessRuntimeImpl)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).startProcess(this.processId, this.params, this.type);
            return null;
        }
    }

    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private StartNode startNode;
        private Trigger trigger;

        public StartProcessEventListener(StartNode startNode, Trigger trigger, String processId, List<EventFilter> eventFilters) {
            this.processId = processId;
            this.eventFilters = eventFilters;
            this.trigger = trigger;
            this.startNode = startNode;
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            boolean bl;
            for (EventFilter eventFilter : this.eventFilters) {
                if (eventFilter.acceptsEvent(type, event, varName -> null)) continue;
                return;
            }
            HashMap<String, Object> outputSet = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : this.trigger.getInMappings().entrySet()) {
                outputSet.put(entry.getKey(), entry.getKey());
            }
            boolean bl2 = false;
            for (DataAssociation dataAssociation : this.trigger.getInAssociations()) {
                if (!"event".equals(dataAssociation.getSources().get(0).getLabel())) continue;
                bl = true;
            }
            if (!bl && !this.trigger.getInAssociations().isEmpty()) {
                String string = (String)this.startNode.getMetaData("TriggerMappingInput");
                outputSet.put(string, event);
            } else {
                outputSet.put("event", event);
            }
            Map<String, Object> map = NodeIoHelper.processOutputs(this.trigger.getInAssociations(), key -> outputSet.get(key));
            ProcessRuntimeImpl.this.startProcessWithParamsAndTrigger(this.processId, map, type, false);
        }
    }
}

