/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.transformation.JsonResolver;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.util.ContextFactory;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.RuleUnitFactory;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.dmn.rest.DMNJSONUtils;
import org.kie.kogito.drools.core.common.KogitoInternalAgenda;
import org.kie.kogito.drools.core.spi.KogitoProcessContextImpl;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;

public class RuleSetNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final String ACT_AS_WAIT_STATE_PROPERTY = "org.jbpm.rule.task.waitstate";
    private static final String FIRE_RULE_LIMIT_PROPERTY = "org.jbpm.rule.task.firelimit";
    private static final String FIRE_RULE_LIMIT_PARAMETER = "FireRuleLimit";
    private static final int DEFAULT_FIRE_RULE_LIMIT = Integer.parseInt(System.getProperty("org.jbpm.rule.task.firelimit", "10000"));
    private Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    private String ruleFlowGroup;
    private final JsonResolver jsonResolver = new JsonResolver();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();

    protected RuleSetNode getRuleSetNode() {
        return (RuleSetNode)this.getNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        block13: {
            try {
                super.internalTrigger(from, type);
                if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
                    return;
                }
                if (!"DROOLS_DEFAULT".equals(type)) {
                    throw new IllegalArgumentException("A RuleSetNode only accepts default incoming connections!");
                }
                RuleSetNode ruleSetNode = this.getRuleSetNode();
                KieRuntime kruntime = Optional.ofNullable(this.getRuleSetNode().getKieRuntime()).orElse(() -> this.getProcessInstance().getKnowledgeRuntime()).get();
                Map<String, Object> inputs = NodeIoHelper.processInputs(this, varRef -> this.getVariable((String)varRef));
                RuleSetNode.RuleType ruleType = ruleSetNode.getRuleType();
                if (ruleType.isDecision()) {
                    DMNContext context;
                    RuleSetNode.RuleType.Decision decisionModel = (RuleSetNode.RuleType.Decision)ruleType;
                    String namespace = this.resolveExpression(decisionModel.getNamespace());
                    String model = this.resolveExpression(decisionModel.getModel());
                    DecisionModel modelInstance = Optional.ofNullable(this.getRuleSetNode().getDecisionModel()).orElse(() -> new DmnDecisionModel((DMNRuntime)((KieSession)kruntime).getKieRuntime(DMNRuntime.class), namespace, model)).get();
                    DMNResult dmnResult = modelInstance.evaluateAll(context = DMNJSONUtils.ctx((DecisionModel)modelInstance, this.jsonResolver.resolveAll(inputs)));
                    if (dmnResult.hasErrors()) {
                        String errors = dmnResult.getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).stream().map(Object::toString).collect(Collectors.joining(", "));
                        throw new RuntimeException("DMN result errors:: " + errors);
                    }
                    Map outputSet = dmnResult.getContext().getAll();
                    NodeIoHelper.processOutputs(this, key -> outputSet.get(key), varName -> this.getVariable((String)varName));
                    this.triggerCompleted();
                    break block13;
                }
                if (ruleType.isRuleFlowGroup()) {
                    this.setRuleFlowGroup(this.resolveRuleFlowGroup(ruleType.getName()));
                    for (Map.Entry<String, Object> entry : inputs.entrySet()) {
                        if (FIRE_RULE_LIMIT_PARAMETER.equals(entry.getKey())) continue;
                        String inputKey = this.getRuleFlowGroup() + "_" + this.getProcessInstance().getStringId() + "_" + entry.getKey();
                        this.factHandles.put(inputKey, kruntime.insert(entry.getValue()));
                    }
                    if (this.actAsWaitState()) {
                        this.addRuleSetListener();
                        ((KogitoInternalAgenda)kruntime.getAgenda()).activateRuleFlowGroup(this.getRuleFlowGroup(), this.getProcessInstance().getStringId(), this.getUniqueId());
                    } else {
                        int fireLimit = DEFAULT_FIRE_RULE_LIMIT;
                        WorkflowProcessInstance processInstance = this.getProcessInstance();
                        if (inputs.containsKey(FIRE_RULE_LIMIT_PARAMETER)) {
                            fireLimit = Integer.parseInt(inputs.get(FIRE_RULE_LIMIT_PARAMETER).toString());
                        }
                        ((KogitoInternalAgenda)kruntime.getAgenda()).activateRuleFlowGroup(this.getRuleFlowGroup(), processInstance.getStringId(), this.getUniqueId());
                        int fired = ((KieSession)kruntime).fireAllRules(processInstance.getAgendaFilter(), fireLimit);
                        if (fired == fireLimit) {
                            throw new RuntimeException("Fire rule limit reached " + fireLimit + ", limit can be set via system property org.jbpm.rule.task.firelimit or via data input of business rule task named FireRuleLimit");
                        }
                        this.removeEventListeners();
                        this.retractFacts(kruntime);
                        this.triggerCompleted();
                    }
                    break block13;
                }
                if (ruleType.isRuleUnit()) {
                    RuleUnitFactory<RuleUnitData> factory = ruleSetNode.getRuleUnitFactory();
                    KogitoProcessContextImpl context = ContextFactory.fromNode(this);
                    RuleUnitData model = factory.bind((ProcessContext)context);
                    RuleUnitInstance instance = factory.unit().createInstance(model);
                    instance.fire();
                    factory.unbind((ProcessContext)context, model);
                    this.triggerCompleted();
                    break block13;
                }
                throw new UnsupportedOperationException("Unsupported Rule Type: " + ruleType);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void handleException(Throwable e) {
        ExceptionScopeInstance exceptionScopeInstance = this.getExceptionScopeInstance(e);
        if (exceptionScopeInstance == null) {
            Throwable rootCause = this.getRootException(e);
            if (rootCause != null && (exceptionScopeInstance = this.getExceptionScopeInstance(rootCause)) != null) {
                KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
                context.setProcessInstance((ProcessInstance)this.getProcessInstance());
                context.setNodeInstance((NodeInstance)this);
                context.getContextData().put("Exception", rootCause);
                exceptionScopeInstance.handleException(rootCause.getClass().getName(), (KogitoProcessContext)context);
                return;
            }
            throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
        }
        KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
        context.setProcessInstance((ProcessInstance)this.getProcessInstance());
        context.setNodeInstance((NodeInstance)this);
        context.getContextData().put("Exception", this.getProcessInstance().getFaultData());
        exceptionScopeInstance.handleException(e.getClass().getName(), (KogitoProcessContext)context);
    }

    private ExceptionScopeInstance getExceptionScopeInstance(Throwable e) {
        return (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", e.getClass().getName());
    }

    protected Throwable getRootException(Throwable exception) {
        Throwable rootException = exception;
        while (rootException.getCause() != null) {
            rootException = rootException.getCause();
        }
        return rootException;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addRuleSetListener();
    }

    private String getRuleSetEventType() {
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        if (kruntime instanceof StatefulKnowledgeSession) {
            return "RuleFlowGroup_" + this.getRuleFlowGroup() + "_" + ((StatefulKnowledgeSession)kruntime).getIdentifier();
        }
        return "RuleFlowGroup_" + this.getRuleFlowGroup();
    }

    private void addRuleSetListener() {
        this.getProcessInstance().addEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener(this.getRuleSetEventType(), this, true);
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.actAsWaitState()) {
            ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).getAgendaGroupsManager().deactivateRuleFlowGroup(this.getRuleFlowGroup());
        }
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (this.getRuleSetEventType().equals(type)) {
            this.removeEventListeners();
            KieRuntime kruntime = Optional.ofNullable(this.getRuleSetNode().getKieRuntime()).orElse(() -> this.getProcessInstance().getKnowledgeRuntime()).get();
            this.retractFacts(kruntime);
            this.triggerCompleted();
        }
    }

    public void retractFacts(KieRuntime kruntime) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        for (Map.Entry<String, FactHandle> entry : this.factHandles.entrySet()) {
            Object object = kruntime.getObject(entry.getValue());
            String key2 = entry.getKey();
            key2 = key2.replaceAll(this.getRuleFlowGroup() + "_", "");
            key2 = key2.replaceAll(this.getProcessInstance().getStringId() + "_", "");
            objects.put(key2, object);
            kruntime.delete(entry.getValue());
        }
        HashMap<String, Object> outputSet = objects;
        NodeIoHelper.processOutputs(this, key -> outputSet.get(key), varName -> this.getVariable((String)varName));
        this.factHandles.clear();
    }

    private String resolveRuleFlowGroup(String origin) {
        return this.resolveExpression(origin);
    }

    public Map<String, FactHandle> getFactHandles() {
        return this.factHandles;
    }

    public void setFactHandles(Map<String, FactHandle> factHandles) {
        this.factHandles = factHandles;
    }

    public String getRuleFlowGroup() {
        if (this.ruleFlowGroup == null || this.ruleFlowGroup.trim().length() == 0) {
            RuleSetNode.RuleType ruleType = this.getRuleSetNode().getRuleType();
            this.ruleFlowGroup = ruleType.isRuleFlowGroup() ? ruleType.getName() : null;
        }
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    protected boolean actAsWaitState() {
        Object asWaitState = this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get(ACT_AS_WAIT_STATE_PROPERTY);
        if (asWaitState != null) {
            return Boolean.parseBoolean(asWaitState.toString());
        }
        return false;
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List list = this.subContextInstances.computeIfAbsent(contextId, key -> new ArrayList());
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getRuleSetNode();
    }
}

