/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.kie.kogito.process.validation.ValidationError;

public class ValidationException
extends RuntimeException {
    private final String processId;
    private final Collection<ValidationError> errors;

    public ValidationException(String processId, Collection<? extends ValidationError> errors) {
        this.processId = processId;
        this.errors = Collections.unmodifiableCollection(errors);
    }

    public ValidationException(String processId, ValidationError error) {
        this(processId, Collections.singleton(error));
    }

    public ValidationException(String processId, String errorMessage) {
        this(processId, Collections.singleton(() -> errorMessage));
    }

    public Collection<ValidationError> getErrors() {
        return this.errors;
    }

    public String getProcessId() {
        return this.processId;
    }

    @Override
    public String getMessage() {
        return this.errors.stream().map(ValidationError::getMessage).collect(Collectors.joining(" "));
    }
}

