/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.KogitoProcessRuntimeImpl;
import org.jbpm.process.instance.event.KogitoProcessEventListenerAdapter;
import org.jbpm.process.instance.event.KogitoProcessEventSupportImpl;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public abstract class AbstractProcessRuntime
implements InternalProcessRuntime {
    protected KogitoProcessEventSupport processEventSupport;
    protected KogitoProcessRuntimeImpl kogitoProcessRuntime = new KogitoProcessRuntimeImpl(this);
    private final Application application;
    private final Map<ProcessEventListener, KogitoProcessEventListener> listenersMap = new IdentityHashMap<ProcessEventListener, KogitoProcessEventListener>();

    protected AbstractProcessRuntime(Application application) {
        this.application = application;
    }

    public KogitoProcessRuntime getKogitoProcessRuntime() {
        return this.kogitoProcessRuntime;
    }

    @Override
    public KogitoProcessEventSupport getProcessEventSupport() {
        return this.processEventSupport;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        throw new UnsupportedOperationException();
    }

    public void addEventListener(ProcessEventListener listener) {
        ((KogitoProcessEventSupportImpl)this.processEventSupport).addEventListener((EventListener)this.asKogitoProcessEventListener(listener));
    }

    public void removeEventListener(ProcessEventListener listener) {
        ((KogitoProcessEventSupportImpl)this.processEventSupport).removeEventListener((EventListener)this.removeKogitoProcessEventListener(listener));
    }

    public List<ProcessEventListener> getProcessEventListeners() {
        return ((KogitoProcessEventSupportImpl)this.processEventSupport).getEventListeners();
    }

    private KogitoProcessEventListener asKogitoProcessEventListener(ProcessEventListener processEventListener) {
        if (processEventListener instanceof KogitoProcessEventListener) {
            return (KogitoProcessEventListener)processEventListener;
        }
        return this.listenersMap.computeIfAbsent(processEventListener, KogitoProcessEventListenerAdapter::new);
    }

    private KogitoProcessEventListener removeKogitoProcessEventListener(ProcessEventListener processEventListener) {
        if (processEventListener instanceof KogitoProcessEventListener) {
            return (KogitoProcessEventListener)processEventListener;
        }
        return this.listenersMap.remove(processEventListener);
    }
}

